/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestManageLinkClosedIssues
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestManageLinksClosedIssues.xml");
    }

    @Test
    public void testManageLinkClosedIssue() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-4");
        List<String> classNames = Arrays.asList(StringUtils.split((String)this.tester.getDialog().getResponse().getLinkWith("HSP-5").getClassName(), (char)' '));
        Assert.assertTrue((String)"Expected one of the classes to be 'resolution'", (boolean)classNames.contains("resolution"));
    }

    @Test
    public void testManageLinkNonClosedIssue() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-5");
        List<String> classNames = Arrays.asList(StringUtils.split((String)this.tester.getDialog().getResponse().getLinkWith("HSP-4").getClassName(), (char)' '));
        Assert.assertFalse((String)"Did not expect the 'resolution' class", (boolean)classNames.contains("resolution"));
        this.textAssertions.assertTextPresent(this.locator.page(), "HSP-4");
    }
}

