/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.google.common.collect.ImmutableList;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestMassArchive
extends BaseJiraFuncTest {
    private static final String MASS_ARCHIVE_PATH = "/rest/api/2/issue/archive";
    private static final FeatureFlag ISSUE_ARCHIVING_FEATURE_FLAG = FeatureFlag.featureFlag((String)"com.atlassian.jira.issues.archiving");
    private CloseableHttpClient restClient;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.backdoor.project().addProject("Project", "PRO", "admin");
        this.restClient = HttpClients.createDefault();
    }

    @Test
    public void testHappyPath() throws IOException {
        List<String> issues = this.createIssues(10);
        CloseableHttpResponse response = this.massArchive(issues, "admin", "admin");
        MatcherAssert.assertThat(this.getIssueKeysFromResponse(response), (Matcher)Matchers.equalTo(issues));
    }

    @Test
    public void testInterruptArchiving() throws IOException {
        List<String> issueKeys = this.createIssues(500);
        CloseableHttpResponse response = this.massArchive(issueKeys, "admin", "admin");
        String responseLine = this.getReader(response).readLine();
        response.close();
        MatcherAssert.assertThat((Object)this.getIssueKey(responseLine), (Matcher)Matchers.equalTo((Object)issueKeys.get(0)));
        MatcherAssert.assertThat((Object)this.backdoor.issues().getIssue((String)issueKeys.get((int)0)).fields.get("archiveddate"), (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
        MatcherAssert.assertThat((Object)this.backdoor.issues().getIssue((String)issueKeys.get((int)(issueKeys.size() - 1))).fields.get("archiveddate"), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void testUserHasNoPermission() throws IOException {
        List<String> issues = this.createIssues(1);
        CloseableHttpResponse response = this.massArchive(issues, "fred", "fred");
        String responseLine = this.getReader(response).readLine();
        Assert.assertTrue((boolean)responseLine.contains(Response.Status.FORBIDDEN.getReasonPhrase()));
    }

    @Test
    public void testArchiveEmptyList() throws IOException {
        this.createIssues(10);
        CloseableHttpResponse response = this.massArchive((Collection<String>)ImmutableList.of(), "admin", "admin");
        MatcherAssert.assertThat(this.getIssueKeysFromResponse(response), (Matcher)Matchers.empty());
    }

    @Test
    public void testArchiveNonExistingIssue() throws IOException {
        ImmutableList issues = ImmutableList.of((Object)"AD-1");
        CloseableHttpResponse response = this.massArchive((Collection<String>)issues, "admin", "admin");
        String responseLine = this.getReader(response).readLine();
        Assert.assertTrue((boolean)responseLine.contains(Response.Status.NOT_FOUND.getReasonPhrase()));
    }

    private List<String> createIssues(int amount) {
        ArrayList<String> issueKeys = new ArrayList<String>();
        for (int i = 1; i <= amount; ++i) {
            issueKeys.add(this.backdoor.issues().createIssue((String)"PRO", (String)new StringBuilder().append((String)"PRO-").append((int)i).toString()).key);
        }
        return issueKeys;
    }

    private Collection<String> getIssueKeysFromResponse(CloseableHttpResponse response) throws IOException {
        BufferedReader reader = this.getReader(response);
        return reader.lines().map(this::getIssueKey).collect(Collectors.toList());
    }

    private String getIssueKey(String line) {
        return line.split(",")[0];
    }

    private BufferedReader getReader(CloseableHttpResponse response) throws IOException {
        return new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
    }

    private CloseableHttpResponse massArchive(Collection<String> issueKeys, String username, String password) throws IOException {
        String json = new GsonBuilder().create().toJson(issueKeys);
        String credentials = String.format("%s:%s", username, password);
        String encodedAuth = new String(Base64.encodeBase64((byte[])credentials.getBytes(StandardCharsets.ISO_8859_1)));
        String authHeader = "Basic " + encodedAuth;
        HttpPost post = new HttpPost(this.environmentData.getBaseUrl().toExternalForm() + MASS_ARCHIVE_PATH);
        post.setHeader("Authorization", authHeader);
        post.setEntity((HttpEntity)new StringEntity(json));
        post.setHeader("Content-type", "application/json");
        return this.restClient.execute((HttpUriRequest)post);
    }
}

