/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestMetaTagOrdering
extends BaseJiraFuncTest {
    private final String SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FEATURE_KEY = "com.atlassian.plugins.dashboard.SEND_HEAD_EARLY.disabled";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testDashboard() {
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.verifyMetaTags();
    }

    @Test
    public void testDashboardWithSendHeadEarlyDisabled() {
        this.backdoor.darkFeatures().enableForSite("com.atlassian.plugins.dashboard.SEND_HEAD_EARLY.disabled");
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.verifyMetaTags();
        this.backdoor.darkFeatures().disableForSite("com.atlassian.plugins.dashboard.SEND_HEAD_EARLY.disabled");
    }

    public void verifyMetaTags() {
        List<Node> headChildren = this.elements(this.locator.css("head").getNode().getChildNodes());
        Node firstChild = headChildren.get(0);
        this.assertTagName("meta", firstChild);
        this.assertAttribute("charset", "utf-8", firstChild);
    }

    private List<Node> elements(NodeList nodes) {
        ArrayList filtered = Lists.newArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (1 != nodes.item(i).getNodeType()) continue;
            filtered.add(nodes.item(i));
        }
        return filtered;
    }

    private void assertTagName(String expected, Node node) {
        Assert.assertEquals((Object)expected, (Object)node.getNodeName());
    }

    private void assertAttribute(String expectedAttribute, String expectedValue, Node node) {
        Assert.assertEquals((Object)expectedValue, (Object)node.getAttributes().getNamedItem(expectedAttribute).getNodeValue());
    }
}

