/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestOpsBarStructure
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestOpsBar.xml");
    }

    @After
    public void after() {
        this.backdoor.plugins().enablePlugin("com.atlassian.jira.dev.reference-plugin");
    }

    @Test
    public void testWorkflows() {
        this.navigation.issue().viewIssue("HSP-1");
        this.assertExtraTransitionsExist();
        this.navigation.issue().viewIssue("HSP-2");
        this.assertOnlyReferenceTransitionExists();
        this.navigation.issue().viewIssue("HSP-3");
        this.assertOnlyReferenceTransitionExists();
        this.navigation.issue().viewIssue("HSP-4");
        this.assertOnlyReferenceTransitionExists();
    }

    private void assertExtraTransitionsExist() {
        this.assertions.assertNodeExists("//a[@id='opsbar-transitions_more']");
    }

    private boolean referencePluginEnabled() {
        return this.tester.getDialog().getElement("reference-operation") != null;
    }

    private void checkReferencePluginIsEnabled() {
        if (!this.referencePluginEnabled()) {
            Assert.fail((String)"You need to have the reference plugin installed when you run this test. To run JIRA with the ref plugin user './jmake debug -rp'");
        }
    }

    private void assertOnlyReferenceTransitionExists() {
        this.checkReferencePluginIsEnabled();
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#reference-operation"));
    }

    @Test
    public void testConjoined() {
        this.navigation.issue().viewIssue("HSP-5");
        String editGroup = "//div[@class='ops-menus aui-toolbar2']/div/div/div[1]";
        this.assertions.assertNodeHasText(editGroup + "/a[1]", "Edit");
        String commentGroup = "//div[@class='ops-menus aui-toolbar2']/div/div/div[2]";
        this.assertions.assertNodeHasText(commentGroup + "/a[1]", "Add comment");
        String operationsGroup = "//div[@class='ops-menus aui-toolbar2']/div/div/div[3]";
        this.assertions.assertNodeHasText(operationsGroup + "/a[1]", "Assign");
        this.assertions.assertNodeDoesNotHaveText(operationsGroup + "/a[1]", "More");
        this.assertions.assertNodeByIdExists("opsbar-operations_more");
    }

    @Test
    public void testLoginButton() {
        this.navigation.logout();
        this.navigation.issue().viewIssue("ANONED-1");
        IdLocator locator = new IdLocator(this.tester, "ops-login-lnk");
        Assert.assertEquals((long)0L, (long)locator.getNodes().length);
        this.navigation.issue().viewIssue("ANON-1");
        locator = new IdLocator(this.tester, "ops-login-lnk");
        Assert.assertEquals((long)1L, (long)locator.getNodes().length);
        this.tester.clickLink("ops-login-lnk");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "Anon viewable issue");
        locator = new IdLocator(this.tester, "ops-login-lnk");
        Assert.assertEquals((long)0L, (long)locator.getNodes().length);
    }
}

