/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REFERENCE_PLUGIN})
@RestoreBlankInstance
public class TestPermissionConditions
extends BaseJiraFuncTest {
    public static final String CONDITIONAL_WEBPANEL_ID_PREFIX = "conditional-webpanel-";
    @Inject
    private Assertions assertions;
    private IssueCreateResponse issue;

    @Before
    public void setUp() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.navigation.login("admin");
        this.issue = this.backdoor.issues().createIssue("HSP", "sum");
    }

    @Test
    public void allPanelsAreShownIfConditionsAreSatisfied() {
        this.navigation.login("admin");
        this.panelIsShown("projectPermissionNew");
        this.panelIsShown("projectPermissionLegacy");
        this.panelIsShown("globalPermissionNew");
        this.panelIsShown("globalPermissionLegacy");
    }

    @Test
    public void panelsAreNotShownIfConditionsAreNotSatisfied() {
        this.navigation.login("fred");
        this.panelIsNotShown("projectPermissionNew");
        this.panelIsNotShown("projectPermissionLegacy");
        this.panelIsNotShown("globalPermissionNew");
        this.panelIsNotShown("globalPermissionLegacy");
    }

    private void panelIsShown(String panelId) {
        this.navigation.issue().viewIssue(this.issue.key);
        this.assertions.assertNodeByIdExists(CONDITIONAL_WEBPANEL_ID_PREFIX + panelId);
    }

    private void panelIsNotShown(String panelId) {
        this.navigation.issue().viewIssue(this.issue.key);
        this.assertions.assertNodeByIdDoesNotExist(CONDITIONAL_WEBPANEL_ID_PREFIX + panelId);
    }
}

