/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
public class TestSearchXmlView
extends BaseJiraFuncTest {
    private static final String HTML_FRAGMENT = "/--><html><body>hi</body>;<!--";
    @Inject
    private Administration administration;

    @Test
    public void testFilterAllIssues() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=200");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[MKY-1]"));
        Assert.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[HSP-2]"));
        Assert.assertTrue((boolean)((Element)nodes.get(2)).getText().startsWith("[HSP-1]"));
    }

    @Test
    public void testFilterAllIssuesWithCustomSort() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=200&sorter/field=issuekey&sorter/order=ASC");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[HSP-1]"));
        Assert.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[HSP-2]"));
        Assert.assertTrue((boolean)((Element)nodes.get(2)).getText().startsWith("[MKY-1]"));
    }

    @Test
    public void testFilterAllIssuesWithCustomSortAndPaging() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=2&sorter/field=issuekey&sorter/order=ASC&pager/start=1");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[HSP-2]"));
        Assert.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[MKY-1]"));
    }

    private long createFilterForAllIssues() {
        return Long.parseLong(this.backdoor.filters().createFilter("", "All Issues"));
    }

    private Document getDocument(WebTester tester) throws IOException, DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(tester.getDialog().getResponse().getInputStream());
    }
}

