/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.AttachmentClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceAttachments.xml")
public class TestViewIssueAttachment
extends BaseJiraRestTest {
    private AttachmentClient attachmentClient;
    private final String attachmentId = "10000";

    @Before
    public void setUpTest() {
        this.attachmentClient = new AttachmentClient((JIRAEnvironmentData)this.environmentData);
    }

    private void grantBrowseAccessToAnonymous() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
    }

    @Test
    public void shouldGiveAccessToFileToAnonymousUserWithPermissions() {
        this.grantBrowseAccessToAnonymous();
        ParsedResponse response = ((AttachmentClient)this.attachmentClient.anonymous()).getResponse("10000");
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    @Test
    public void shouldNotGiveAccessToAnonymousUserWithoutPermissions() {
        ParsedResponse response = ((AttachmentClient)this.attachmentClient.anonymous()).getResponse("10000");
        Assert.assertEquals((long)403L, (long)response.statusCode);
    }
}

