/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import org.junit.After;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestAssignToMe.xml")
public class TestViewIssueWithRest
extends BaseJiraFuncTest {
    @After
    public void tearDownTest() {
        this.backdoor.userProfile().changeUserLanguage("admin", "");
    }

    @Test
    public void testRestViewIsTranslated() throws IOException {
        this.changeLanguageViewToFrench();
        this.translateBugToFrench();
        this.changeUserLanguage();
        this.tester.gotoPage("/rest/api/2/issue/MKY-1");
        this.tester.assertTextPresent("French_Bug");
        this.tester.assertTextPresent("French_Desc");
    }

    private void changeLanguageViewToFrench() throws IOException {
        this.tester.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=issuetype");
        this.tester.setWorkingForm("changeTranslationLocale");
        this.tester.setFormElement("selectedLocale", "fr_FR");
        this.tester.submit("view");
        this.tester.assertTextPresent("Translation Language: French (France)");
    }

    private void translateBugToFrench() throws IOException {
        this.tester.setWorkingForm("update");
        this.tester.setFormElement("jira.translation.Issue Type.1.name", "French_Bug");
        this.tester.setFormElement("jira.translation.Issue Type.1.desc", "French_Desc");
        this.tester.submit("update");
        this.tester.assertTextPresent("French_Bug");
        this.tester.assertTextPresent("French_Desc");
    }

    private void changeUserLanguage() throws IOException {
        this.tester.gotoPage("/secure/ViewProfile.jspa");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.setWorkingForm("update-user-preferences");
        this.tester.setFormElement("userLocale", "fr_FR");
        this.tester.submit();
        this.tester.assertTextPresent("fran\u00e7ais (France)");
    }
}

