/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestViewIssueWithShowWhenEmptyIndicator
extends BaseJiraFuncTest {
    private static final String SCREEN_NAME = "Default Screen";
    private static final long SCREEN_ID = 1L;
    private static final String TAB_NAME = "Field Tab";
    private static final int TAB_POSITION = 0;
    private static final String CUSTOM_FIELD_NAME = "cf";
    private static final String CUSTOM_FIELD_ID = "customfield_10000";
    private static final String CUSTOM_FIELD_DIV_ID = "customfield_10000-val";
    private static final String CUSTOM_FIELD_TEXT = "test";
    private String issueKey;

    @Before
    public void setUp() {
        this.createCustomFieldAndAddToScreen();
        this.issueKey = this.createIssue();
    }

    @Test
    public void customFieldShouldNotBeDisplayedIfIsMarkedAsNotShownWhenEmptyAndHasNoValue() {
        this.setShowWhenEmptyForField(false);
        this.goToIssue();
        this.setCustomFieldValue(null);
        this.assertions.assertNodeByIdDoesNotExist(CUSTOM_FIELD_DIV_ID);
    }

    @Test
    public void customFieldShouldBeDisplayedIfIsMarkedAsNotShownWhenEmptyAndHasValue() {
        this.setShowWhenEmptyForField(false);
        this.goToIssue();
        this.setCustomFieldValue(CUSTOM_FIELD_TEXT);
        this.assertions.assertNodeByIdHasText(CUSTOM_FIELD_DIV_ID, CUSTOM_FIELD_TEXT);
    }

    @Test
    public void customFieldShouldBeDisplayedIfIsMarkedAsShownWhenEmptyAndHasNoValue() {
        this.setShowWhenEmptyForField(true);
        this.goToIssue();
        this.setCustomFieldValue(null);
        this.assertions.assertNodeByIdHasText(CUSTOM_FIELD_DIV_ID, "None");
    }

    @Test
    public void customFieldShouldBeDisplayedIfIsMarkedAsShownWhenEmptyAndHasValue() {
        this.setShowWhenEmptyForField(true);
        this.goToIssue();
        this.setCustomFieldValue(CUSTOM_FIELD_TEXT);
        this.assertions.assertNodeByIdHasText(CUSTOM_FIELD_DIV_ID, CUSTOM_FIELD_TEXT);
    }

    private void createCustomFieldAndAddToScreen() {
        this.backdoor.customFields().createCustomField(CUSTOM_FIELD_NAME, "description", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher");
        this.backdoor.screens().addFieldToScreenTab(SCREEN_NAME, TAB_NAME, CUSTOM_FIELD_NAME, "");
    }

    private void setShowWhenEmptyForField(boolean showWhenEmpty) {
        this.backdoor.screens().setShowWhenEmpty(1L, 0, CUSTOM_FIELD_ID, showWhenEmpty);
    }

    private String createIssue() {
        return this.navigation.issue().createIssue("homosapien", "Bug", "Test");
    }

    private void goToIssue() {
        this.navigation.issue().gotoIssue(this.issueKey);
    }

    private void setCustomFieldValue(String value) {
        this.navigation.issue().setFreeTextCustomField(this.issueKey, CUSTOM_FIELD_ID, value);
    }
}

