/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@HttpUnitConfiguration(throwOnErrorStatus=false)
public class TestXmlIssueViewErrors
extends BaseJiraFuncTest {
    private static final String SAMPLE_PATH_MESSAGE_1 = "Invalid path format.";
    private static final String SAMPLE_PATH_MESSAGE_2 = "Path should be of format";
    private static final String SAMPLE_PATH_MESSAGE_3 = "/si/jira.issueviews:xml/JRA-10/JRA-10.xml";

    @Test
    public void testMalformedUrls() throws Exception {
        this.assert400SamplePathMessage("/si");
        this.assert400SamplePathMessage("/si/");
        this.assert400SamplePathMessage("/si/unknownplugin");
        this.assert400SamplePathMessage("/si/unknownplugin/");
        this.assert400SamplePathMessage("/si/unknownplugin/blah");
        this.assert400BadPlugin("/si/unknownplugin/blah/");
        this.assert404BadKey("/si/jira.issueviews:issue-xml/badkey/");
    }

    private void assert404BadKey(String url) throws IOException {
        this.tester.beginAt(url);
        Assert.assertThat((Object)new Error404(this.tester), Error404.isOn404Page());
    }

    private void assert400SamplePathMessage(String url) {
        this.assertResponseCode(url, 400);
        this.tester.assertTextPresent("Invalid path format. Path should be of format /si/jira.issueviews:xml/JRA-10/JRA-10.xml".replace("/", "&#47;"));
    }

    private void assert400BadPlugin(String url) {
        this.assertResponseCode(url, 400);
        this.tester.assertTextPresent("Could not find any enabled plugin with key");
    }

    private void assertResponseCode(String url, int code) {
        this.tester.beginAt(url);
        WebResponse webResponse = this.tester.getDialog().getResponse();
        Assert.assertEquals((long)code, (long)webResponse.getResponseCode());
    }
}

