/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
@HttpUnitConfiguration(throwOnErrorStatus=false)
public class TestXmlIssueViewXss
extends BaseJiraFuncTest {
    private static final String XSS_ALERT_RAW = "\"alert('surprise!')";
    private static final String XSS_ALERT_XML_ESCAPED = "&quot;alert(&apos;surprise!&apos;)";
    private static final String HTML_FRAGMENT = "/--><html><body>hi</body>;<!--";
    @Inject
    private Administration administration;

    @After
    public void tearDownTest() {
        this.navigation.login("admin");
    }

    @Test
    public void testXssInModuleKeyParam() throws IOException {
        this.tester.gotoPage("/si/jira.issueviews:<script>alert('XSS')<script>/HSP-1/HSP-1.xml");
        Assert.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("<script>alert('XSS')<script>"));
    }

    @Test
    public void testXssInIssueKeyParam() throws IOException {
        this.tester.gotoPage("/si/jira.issueviews:HSP/<script>alert('XSS')<script>");
        Assert.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("<script>alert('XSS')<script>"));
    }

    @Test
    public void testUsernameAndFullnameEscaping() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        this.navigation.login(XSS_ALERT_RAW, "password");
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug");
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_XML_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    @Test
    public void testUsernameAndFullnameEscapingOnUserPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        String cfId = this.createCustomField("test-xss", this.builtInCustomFieldKey("userpicker"), this.builtInCustomFieldKey("userpickergroupsearcher"));
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug", (Map<String, String[]>)ImmutableMap.of((Object)cfId, (Object)new String[]{XSS_ALERT_RAW}));
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_XML_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    @Test
    public void testFullnamePresentOnUserPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        String cfId = this.createCustomField("test-xss", this.builtInCustomFieldKey("userpicker"), this.builtInCustomFieldKey("userpickergroupsearcher"));
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug", (Map<String, String[]>)ImmutableMap.of((Object)cfId, (Object)new String[]{XSS_ALERT_RAW}));
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent("<customfieldvalue displayname=\"&quot;alert(&apos;surprise!&apos;)\">&quot;alert(&apos;surprise!&apos;)</customfieldvalue>");
    }

    private String builtInCustomFieldKey(String cfType) {
        return String.format("%s:%s", "com.atlassian.jira.plugin.system.customfieldtypes", cfType);
    }

    @Test
    public void testUsernameAndFullnameEscapingOnMultiUserPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        String cfId = this.createCustomField("test-xss", this.builtInCustomFieldKey("multiuserpicker"), this.builtInCustomFieldKey("userpickergroupsearcher"));
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug", (Map<String, String[]>)ImmutableMap.of((Object)cfId, (Object)new String[]{XSS_ALERT_RAW, "admin"}));
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent("<customfieldvalue displayname=\"&quot;alert(&apos;surprise!&apos;)\"><![CDATA[\"alert('surprise!')]]></customfieldvalue>");
        this.assertions.getTextAssertions().assertTextPresentNumOccurences(XSS_ALERT_RAW, 1);
    }

    private String createCustomField(String name, String type, String searcherKey) {
        String cfId = this.backdoor.customFields().createCustomField(name, "", type, searcherKey);
        this.backdoor.screens().addFieldToScreen("Default Screen", name);
        return cfId;
    }
}

