/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestAssignToCurrentUserFunction
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.administration.restoreData("TestAssignToCurrentUserFunction.xml");
    }

    @Test
    public void testAssignToCurrentUserWithNoAssignIssuePermission() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Assignee:", "Administrator", "Reporter:", "Administrator"});
    }

    @Test
    public void testAssignToCurrentUserWithNoAssignableUserPermission() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-users");
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
    }

    @Test
    public void testAssignToCurrentUser() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Assignee:", "Administrator", "Reporter:", "Administrator"});
    }
}

