/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@Restore(value="TestAssignToMe.xml")
public class TestAssignToMe
extends BaseJiraFuncTest {
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.navigation.login("admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testAssignToMeWhenTheUserReportedTheIssue() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Fred Normal");
        this.textAssertions.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.tester.clickLink("assign-to-me");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Administrator");
        this.textAssertions.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    @Test
    public void testAssignToMeWhenUserNamesContainNonAlphaNumericCharacters() {
        this.navigation.logout();
        this.navigation.login("#test");
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Fred Normal");
        this.textAssertions.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.tester.clickLink("assign-to-me");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "#test");
        this.tester.assertLinkNotPresent("assign-to-me");
        this.textAssertions.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.navigation.logout();
        this.navigation.login("admin");
    }

    @Test
    public void testAssignToMeNotVisibleIfNoAssignIssuePermission() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    @Test
    public void testAssignToMeNotVisibleIfNoAssignableUserPermission() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-users");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    @Test
    public void testAssignToMeNotVisibleIfIssueIsNotEditable() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.navigation.issue().closeIssue("MKY-1", "Fixed", "Fixed");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    @Test
    public void testAssignToMeNotVisibleIfAnonymousUser() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.navigation.logout();
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Fred Normal");
        this.tester.assertLinkNotPresent("assign-to-me");
    }
}

