/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestAssignUserProgress
extends BaseJiraFuncTest {
    public static final String TEST_SUMMARY = "testing progress inconsistency";
    public static final String IN_PROGRESS = "In Progress";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
    }

    @After
    public void tearDownTest() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
    }

    @Test
    public void testChangeProgressWithAssign() {
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.backdoor.usersAndGroups().addUserToGroup("bob", "jira-developers");
        this.administration.project().addProject("homosapien", "HSP", "admin");
        String key = this.navigation.issue().createIssue("homosapien", "Bug", TEST_SUMMARY);
        this.navigation.issue().viewIssue(key);
        this.workflowUtil.clickAction("action_id_4");
        this.navigation.issue().assignIssue(key, TEST_SUMMARY, "Bob The Builder");
        this.textAssertions.assertTextPresent(this.locator.page(), IN_PROGRESS);
    }

    @Test
    public void testChangeProgressWithEdit() {
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.backdoor.usersAndGroups().addUserToGroup("bob", "jira-developers");
        this.administration.project().addProject("homosapien", "HSP", "admin");
        String key = this.navigation.issue().createIssue("homosapien", "Bug", TEST_SUMMARY);
        this.navigation.issue().viewIssue(key);
        this.workflowUtil.clickAction("action_id_4");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("assignee", "Bob The Builder");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.page(), IN_PROGRESS);
    }
}

