/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.clone;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.issue.AbstractCloneIssueTest;
import java.io.File;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.CLONE_ISSUE})
@LoginAs(user="admin")
public class TestCloneIssueAttachments
extends AbstractCloneIssueTest {
    private static final String ATTACHMENT_FILE_NAME_1 = "info.txt";
    private static final String ATTACHMENT_FILE_NAME_2 = "anotherfile.txt";
    private static final String ATTACHMENT_CONTENTS_1 = "AAAAA";
    private static final String ATTACHMENT_CONTENTS_2 = "BBBBB";
    private static final String CLONE_ATTACHMENTS_CHECKBOX_NAME = "cloneAttachments";
    private static final String ORIGINAL_ISSUE_KEY = "RAT-1";
    private static final String ORIGINAL_SUBTASK_KEY_1 = "RAT-2";
    private static final String ORIGINAL_SUBTASK_KEY_3 = "RAT-4";
    private static final String ORIGINAL_COW_ISSUE_KEY = "COW-16";
    private static final String ATTACH_FILE_ISSUE_OPERATION_LINK_ID = "attach-file";
    private static final String DESIGN_ATTACHMENT_FILE_NAME_1 = "design_attachment_1.txt";
    private static final String DESIGN_ATTACHMENT_FILE_NAME_2 = "design_attachment_2.txt";
    private static final String DESIGN_ATTACHMENT_CONTENTS_1 = "Design Attachments Stuff";
    private static final String DESIGN_ATTACHMENT_CONTENTS_2 = "Some other Design Attachments Stuff";
    private static final String IMPLEMENT_ATTACHMENT_FILE_NAME_1 = "implment_attachment_1.txt";
    private static final String IMPLEMENT_ATTACHMENT_CONTENTS_1 = "Implement Attachments Stuff";
    private static final String COW_ATTACHMENT_FILE_NAME_1 = "cowfile.txt";
    private static final String CLONE_ATTACHMENTS_CHECKBOX_LABEL = "Clone attachments";
    private static final String CLONE_ISSUE_OPERATION_NAME = "clone-issue";
    private static final String SUMMARY_FIELD_ID = "summary";
    private static final String CLONE_SUBTASKS_CHECK_BOX_ID = "cloneSubTasks";
    private static final String CREATE_BUTTON_NAME = "Create";
    private static final String CLONEISSUE_CLONE_ATTACHMENTS_FAILED = "cloneissue.clone.attachments.failed.multiple.title";
    private static final String CLONEISSUE_CLONE_WARNING_CONTINUE_TO_ISSUE = "cloneissue.clone.attachments.failed.continue.to.issue";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestCloneIssueAttachments.xml");
        this.administration.attachments().enable();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        File attachmentsDir = new File(this.getEnvironmentData().getXMLDataLocation(), "TestCloneIssueAttachments/attachments");
        this.backdoor.attachmentFile().copyAttachments(attachmentsDir.getAbsolutePath());
    }

    @Test
    public void testCloneAttachmentsDisabled() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresent(ATTACH_FILE_ISSUE_OPERATION_LINK_ID);
        this.administration.attachments().disable();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkNotPresent(ATTACH_FILE_ISSUE_OPERATION_LINK_ID);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    @Test
    public void testCloneAttachmentsAvailable() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_3).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().viewIssue(ORIGINAL_COW_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(COW_ATTACHMENT_FILE_NAME_1);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_COW_ISSUE_KEY).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_COW_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    @Test
    public void testCloneAttachmentsAvailableForSubTasks() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    @Test
    public void testCloneNoLinksNoSubTasksNoAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.submit(CREATE_BUTTON_NAME);
        this.waitForProgress();
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
    }

    @Test
    public void testCloneNoLinksNoSubTasksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.waitForProgress();
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.issue().attachments(cloneIssueKey).manage().delete();
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
    }

    @Test
    public void testCloneWithAttachmentsShowsErrorWhenSomeAttachmentsFailToCopy() {
        this.backdoor.attachmentFile().cleanAttachments();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.waitForProgress();
        String cloneAttachmentsFailedText = this.backdoor.i18n().getText(CLONEISSUE_CLONE_ATTACHMENTS_FAILED, "en_US").replace("{0}", "2").replace("{1}", "2").replace("'", "&#39;");
        String continueToIssueText = this.backdoor.i18n().getText(CLONEISSUE_CLONE_WARNING_CONTINUE_TO_ISSUE, "en_US");
        this.tester.assertTextPresent(cloneAttachmentsFailedText);
        this.tester.assertLinkPresentWithText(continueToIssueText);
        this.tester.clickLinkWithText(continueToIssueText);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
    }

    @Test
    public void testCloneNoLinksWithSubTasksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertFormElementEquals(CLONE_SUBTASKS_CHECK_BOX_ID, "true");
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.waitForProgress();
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.clickLinkWithExactText("CLONE - Design Solution");
        String cloneSubtaskIssueKey1 = this.extractIssueKey();
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.clickLinkWithExactText("CLONE - Implement Solution");
        String cloneSubtaskIssueKey2 = this.extractIssueKey();
        this.tester.clickLinkWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(IMPLEMENT_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().attachments(cloneIssueKey).manage().delete();
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
        this.navigation.issue().attachments(cloneSubtaskIssueKey1).manage().delete();
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
        this.navigation.issue().attachments(cloneSubtaskIssueKey2).manage().delete();
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey2);
        this.tester.assertLinkNotPresentWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_3);
        this.tester.assertLinkPresentWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.clickLinkWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(IMPLEMENT_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_3).manage().delete();
    }

    @Test
    public void testCloneSubTaskNoLinksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Sub-Task";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Sub-Task");
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.waitForProgress();
        this.tester.assertTextPresent("CLONE - Sub-Task");
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.issue().attachments(cloneIssueKey).manage().delete();
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
    }

    @Test
    public void testProgressShownForSlowCloningOperation() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.backdoor.barrier().raiseBarrierAndRun("cloneIssue", barrier -> {
            this.tester.submit(CREATE_BUTTON_NAME);
            this.tester.assertFormPresent("cloneissueprogressform");
        });
        this.waitForProgress();
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
    }

    private String extractIssueKey() {
        IdLocator locator = new IdLocator(this.tester, "key-val");
        return locator.getRawText();
    }
}

