/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.clone;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.issue.AbstractCloneIssueTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestCloneIssueLinking
extends AbstractCloneIssueTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestCloneIssueLinking.xml");
    }

    @Test
    public void testCloneNoLinksNoSubtasks() throws Exception {
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("clone-issue");
        this.tester.setFormElement("summary", "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox("cloneSubTasks");
        this.tester.submit("Create");
        this.waitForProgress();
        this.tester.assertTextPresent("RAT-4");
        this.tester.assertTextNotPresent("COW-16");
        this.tester.assertTextNotPresent("RAT-3");
        this.tester.assertTextNotPresent("Google Search");
        this.tester.assertTextNotPresent("Sub-Tasks");
        this.tester.assertTextNotPresent("Design Solution");
    }

    @Test
    public void testCloneLinksNoSubtasks() throws Exception {
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("clone-issue");
        this.tester.setFormElement("summary", "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.checkCheckbox("cloneLinks", "true");
        this.tester.uncheckCheckbox("cloneSubTasks");
        this.tester.submit("Create");
        this.waitForProgress();
        this.tester.assertTextPresent("RAT-4");
        this.tester.assertTextPresent("COW-16");
        this.tester.assertTextPresent("RAT-3");
        this.tester.assertTextPresent("Google Search");
        this.tester.assertTextNotPresent("Sub-Tasks");
        this.tester.assertTextNotPresent("Design Solution");
    }

    @Test
    public void testCloneNoLinksSubtasks() throws Exception {
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("clone-issue");
        this.tester.setFormElement("summary", "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.submit("Create");
        this.waitForProgress();
        this.tester.assertTextPresent("RAT-4");
        this.tester.assertTextNotPresent("COW-16");
        this.tester.assertTextNotPresent("RAT-3");
        this.tester.assertTextNotPresent("Google Search");
        this.tester.assertTextPresent("Sub-Tasks");
        this.tester.assertTextPresent("Design Solution");
    }

    @Test
    public void testCloneLinks() throws Exception {
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("clone-issue");
        this.tester.setFormElement("summary", "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.checkCheckbox("cloneLinks", "true");
        this.tester.submit("Create");
        this.waitForProgress();
        this.tester.assertTextPresent("RAT-4");
        this.tester.assertTextPresent("COW-16");
        this.tester.assertTextNotPresent("RAT-3");
        this.tester.assertTextPresent("RAT-6");
        this.tester.assertTextPresent("Google Search");
        this.navigation.issue().viewIssue("RAT-5");
        this.tester.assertTextPresent("Design Solution");
        this.tester.assertTextPresent("RAT-6");
        this.tester.assertTextNotPresent("RAT-3");
        this.tester.assertTextPresent("COW-18");
        this.tester.assertTextPresent("Bing Search");
        this.navigation.issue().viewIssue("RAT-6");
        this.tester.assertTextPresent("Create Estimate");
        this.tester.assertTextPresent("COW-17");
        this.tester.assertTextNotPresent("RAT-1");
        this.tester.assertTextNotPresent("RAT-2");
        this.tester.assertTextPresent("RAT-4");
        this.tester.assertTextPresent("RAT-5");
    }
}

