/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.history;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestRecentIssueHistory
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testVisitedIssues() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        this.assertHistoryhasTheseIssues(new String[0]);
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_2, HSP_1});
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1, HSP_3, HSP_2});
        issueNavigation.viewIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1, HSP_3});
    }

    @Test
    public void testVisitedIssuesForNotLoggedIn() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        this.tester.gotoPage(this.page.addXsrfToken("secure/admin/AddPermission.jspa?permissions=" + ProjectPermissions.BROWSE_PROJECTS.permissionKey() + "&schemeId=0&type=group"));
        this.assertHistoryhasTheseIssues(new String[0]);
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_2, HSP_1});
        this.navigation.logout();
        this.assertHistoryhasTheseIssues(new String[0]);
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        issueNavigation.viewIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        this.navigation.login("admin");
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1, HSP_3});
        this.navigation.logout();
        this.assertHistoryhasTheseIssues(new String[0]);
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        issueNavigation.viewIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1, HSP_2});
        this.navigation.login("admin");
        issueNavigation.viewIssue(HSP_3);
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_1, HSP_2});
    }

    @Test
    public void testDeletedIssuesChangesHistory() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_2, HSP_1});
        this.deleteIssue(HSP_3);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        this.deleteIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        this.deleteIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[0]);
    }

    @Test
    public void testOrdering() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        SearchClient searchClient = new SearchClient((JIRAEnvironmentData)this.environmentData);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.fields(new String[]{"key"}).jql("order by lastViewed DESC");
        SearchResult result = searchClient.getSearch(searchRequest);
        Assert.assertEquals((long)3L, (long)result.issues.size());
        Assert.assertEquals((Object)"HSP-3", (Object)((Issue)result.issues.get((int)0)).key);
        Assert.assertEquals((Object)"HSP-2", (Object)((Issue)result.issues.get((int)1)).key);
        Assert.assertEquals((Object)"HSP-1", (Object)((Issue)result.issues.get((int)2)).key);
        searchRequest.jql("order by lastViewed ASC");
        result = searchClient.getSearch(searchRequest);
        Assert.assertEquals((long)3L, (long)result.issues.size());
        Assert.assertEquals((Object)"HSP-1", (Object)((Issue)result.issues.get((int)0)).key);
        Assert.assertEquals((Object)"HSP-2", (Object)((Issue)result.issues.get((int)1)).key);
        Assert.assertEquals((Object)"HSP-3", (Object)((Issue)result.issues.get((int)2)).key);
        this.tester.gotoPage(this.page.addXsrfToken("secure/admin/AddPermission.jspa?permissions=" + ProjectPermissions.BROWSE_PROJECTS + "&schemeId=0&type=group"));
        this.navigation.logout();
        this.navigation.login("fred");
        searchClient.loginAs("fred");
        searchRequest.jql("order by lastViewed DESC");
        result = searchClient.getSearch(searchRequest);
        Assert.assertEquals((long)3L, (long)result.issues.size());
        Assert.assertEquals((Object)"HSP-1", (Object)((Issue)result.issues.get((int)0)).key);
        Assert.assertEquals((Object)"HSP-2", (Object)((Issue)result.issues.get((int)1)).key);
        Assert.assertEquals((Object)"HSP-3", (Object)((Issue)result.issues.get((int)2)).key);
        issueNavigation.viewIssue(HSP_3);
        result = searchClient.getSearch(searchRequest);
        Assert.assertEquals((long)3L, (long)result.issues.size());
        Assert.assertEquals((Object)"HSP-3", (Object)((Issue)result.issues.get((int)0)).key);
        Assert.assertEquals((Object)"HSP-1", (Object)((Issue)result.issues.get((int)1)).key);
        Assert.assertEquals((Object)"HSP-2", (Object)((Issue)result.issues.get((int)2)).key);
        issueNavigation.viewIssue(HSP_2);
        result = searchClient.getSearch(searchRequest);
        Assert.assertEquals((long)3L, (long)result.issues.size());
        Assert.assertEquals((Object)"HSP-2", (Object)((Issue)result.issues.get((int)0)).key);
        Assert.assertEquals((Object)"HSP-3", (Object)((Issue)result.issues.get((int)1)).key);
        Assert.assertEquals((Object)"HSP-1", (Object)((Issue)result.issues.get((int)2)).key);
        searchRequest.jql("order by lastViewed ASC");
        result = searchClient.getSearch(searchRequest);
        Assert.assertEquals((long)3L, (long)result.issues.size());
        Assert.assertEquals((Object)"HSP-1", (Object)((Issue)result.issues.get((int)0)).key);
        Assert.assertEquals((Object)"HSP-3", (Object)((Issue)result.issues.get((int)1)).key);
        Assert.assertEquals((Object)"HSP-2", (Object)((Issue)result.issues.get((int)2)).key);
    }

    private void deleteIssue(String issueKey) {
        this.tester.setWorkingForm("quicksearch");
        this.tester.setFormElement("searchString", issueKey);
        this.tester.submit();
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
    }

    private void assertHistoryhasTheseIssues(String[] issueKeys) {
        this.tester.gotoPage("secure/RecentIssueHistory.jspa?json=true&decorator=none");
        String webPageText = this.tester.getDialog().getResponseText();
        if (issueKeys.length == 0) {
            this.textAssertions.assertTextSequence(webPageText, new String[]{"[", "]"});
        } else {
            this.textAssertions.assertTextSequence(webPageText, issueKeys);
        }
        this.tester.gotoPage("secure/RecentIssueHistory.jspa");
        if (issueKeys.length == 0) {
            this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "No issues in your history");
        } else {
            TableLocator tableLocator = new TableLocator(this.tester, "recent_history_list");
            int rowCount = tableLocator.getTable().getRowCount();
            int colCount = tableLocator.getTable().getColumnCount();
            Assert.assertEquals((long)2L, (long)colCount);
            for (int i = 0; i < issueKeys.length; ++i) {
                String issueKey = issueKeys[i];
                TableCellLocator cellLocator = new TableCellLocator(this.tester, "recent_history_list", i, 0);
                Assert.assertEquals((Object)issueKey, (Object)cellLocator.getText());
            }
        }
    }
}

