/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.links;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

@RestoreBlankInstance
@LoginAs(user="admin")
@WebTest(value={Category.FUNC_TEST, Category.ISSUE_LINKS, Category.JQL})
public class TestSearchByIssueLinkType
extends BaseJiraFuncTest {
    private IssueCreateResponse firstIssue;
    private IssueCreateResponse secondIssue;
    private IssueCreateResponse anotherIssue;
    private IssueCreateResponse unlinkedIssue;

    @Before
    public void prepare() {
        this.backdoor.issueLinking().enable();
        this.backdoor.issueLinking().createIssueLinkType("issueLink", "out", "in");
        this.backdoor.issueLinking().createIssueLinkType("otherLink", "outgoing", "incoming");
        this.backdoor.issueLinking().createIssueLinkType("symmetricalLink", "link", "link");
        this.firstIssue = this.backdoor.issues().createIssue("HSP", "first issue");
        this.secondIssue = this.backdoor.issues().createIssue("MKY", "second issue");
        this.anotherIssue = this.backdoor.issues().createIssue("HSP", "another issue");
        this.unlinkedIssue = this.backdoor.issues().createIssue("MKY", "unlinked issue");
        this.navigation.issue().linkIssueWithComment(this.firstIssue.key, "out", this.secondIssue.key, null, null);
        this.navigation.issue().linkIssueWithComment(this.secondIssue.key, "outgoing", this.anotherIssue.key, null, null);
        this.navigation.issue().linkIssueWithComment(this.firstIssue.key, "link", this.anotherIssue.key, null, null);
    }

    @Test
    public void shouldSearchByEqInwardLink() {
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType = 'in'"));
        this.assertThatResultContainsOnly(searchResult, this.secondIssue);
    }

    @Test
    public void shouldSearchByEqOutwardLink() {
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType = out"));
        this.assertThatResultContainsOnly(searchResult, this.firstIssue);
    }

    @Test
    public void shouldSearchByInInwardLink() {
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType in('in', incoming)"));
        this.assertThatResultContainsOnly(searchResult, this.secondIssue, this.anotherIssue);
    }

    @Test
    public void shouldSearchByInOutwardLink() {
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType in(out, outgoing)"));
        this.assertThatResultContainsOnly(searchResult, this.firstIssue, this.secondIssue);
    }

    @Test
    public void shouldSearchBySymmetricalLink() {
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType = link"));
        this.assertThatResultContainsOnly(searchResult, this.firstIssue, this.anotherIssue);
    }

    @Test
    public void queryShouldBeStableWhenIssueLinksAreBeingChanged() {
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType = link"));
        Assume.assumeTrue((result.total == 2 ? 1 : 0) != 0);
        this.navigation.issue().linkIssueWithComment(this.unlinkedIssue.key, "link", this.anotherIssue.key, null, null);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issueLinkType = link"));
        this.assertThatResultContainsOnly(result, this.firstIssue, this.anotherIssue, this.unlinkedIssue);
        Assert.assertEquals((long)3L, (long)result.total.intValue());
    }

    private void assertThatResultContainsOnly(SearchResult result, IssueCreateResponse ... expectedIssues) {
        List issueKeys = result.issues.stream().map(issue -> issue.key).collect(Collectors.toList());
        MatcherAssert.assertThat(issueKeys, (Matcher)Matchers.containsInAnyOrder((Collection)Stream.of(expectedIssues).map(issue -> Matchers.equalTo((Object)issue.key)).collect(Collectors.toList())));
    }
}

