/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.MOVE_ISSUE})
@LoginAs(user="admin")
public class TestMoveIssue
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY_TO_MOVE = "HSP-1";
    private static final String ISSUE_KEY_NORMAL = "HSP-2";
    private static final String ANA_3 = "ANA-3";
    private static final String CURRENT_ISSUE_TYPE = "Current Issue Type";
    private static final String ANOTHER_TEST_PROJECT = "another test";
    private static final String NEW_ISSUE_TYPE = "New Issue Type";
    private static final String MORE_TESTS_ISSUE_TYPE = "more tests";
    private static final String ISSUETYPE_REQUEST_PARAM = "issuetype";
    private static final String PID_REQUEST_PARAM = "pid";
    private static final String JIRAFORM = "jiraform";
    private static final String MOVE_SUBMIT = "Move";
    private static final String RESULTING_ISSUE_TST_3 = "TST-3";
    private static final String TEST_PROJECT = "Test";
    private static final String TEST_PROJECT_KEY = "TST";
    private static final String MOVE_ISSUE_LINK = "move-issue";
    private static final String NEXT_GT_GT = "Next >>";
    private static final String NEXT = "Next";
    private static final String CHANGE_HISTORY_LINK_ID = "changehistory-tabpanel-link";
    private static final String STATUS_FIELD = "status";
    private static final String PROJECT_FIELD = "project";
    private static final String ISSUE_TYPE_FIELD = "issuetype";
    @Inject
    private HtmlPage page;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Indexing indexing;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private WorkflowUtil workflowUtil;
    @Inject
    private Parser parser;

    @After
    public void restoreDefaultUserPicker() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
    }

    @Test
    @Restore(value="TestMoveIssue.xml")
    public void testMoveIssue() {
        this.moveOperationFunctionality(ISSUE_KEY_TO_MOVE);
        this.moveOperationWithMoveIssuesPermission(ISSUE_KEY_NORMAL);
        this.moveOperationWithInvalidDueDate(ISSUE_KEY_NORMAL);
        this.moveOperationWithDueDateRequired(ISSUE_KEY_NORMAL);
        this.moveOperationWithRequiredFields(ISSUE_KEY_NORMAL);
        this.navigation.issue().deleteIssue(ISSUE_KEY_NORMAL);
        this.navigation.issue().deleteIssue(ISSUE_KEY_TO_MOVE);
    }

    @Test
    @Restore(value="TestMoveIssueIssueTypeAvailable.xml")
    public void testMoveIssueIssueTypeAvailable() {
        this.logger.log((Object)"Move Operation: Test the visibility of the Issue Type field on move.");
        String projectId = this.backdoor.project().getProjectId(TEST_PROJECT_KEY).toString();
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)ANA_3, (Object)"type", (Object)ANOTHER_TEST_PROJECT), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)RESULTING_ISSUE_TST_3, (Object)"title", (Object)"[TST-3] Test"), ANA_3);
        this.navigation.issue().gotoIssue(ANA_3);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.assertTextPresent(CURRENT_ISSUE_TYPE);
        this.tester.assertTextPresent(ANOTHER_TEST_PROJECT);
        this.tester.assertTextPresent(NEW_ISSUE_TYPE);
        this.navigation.issue().selectIssueType(MORE_TESTS_ISSUE_TYPE, "issuetype");
        this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
        this.tester.submit();
        this.tester.getDialog().setWorkingForm(JIRAFORM);
        this.tester.submit();
        this.tester.assertTextPresent(ANOTHER_TEST_PROJECT);
        this.tester.assertTextPresent(MORE_TESTS_ISSUE_TYPE);
        this.tester.submit(MOVE_SUBMIT);
        this.tester.assertTextPresent(RESULTING_ISSUE_TST_3);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)RESULTING_ISSUE_TST_3, (Object)"type", (Object)MORE_TESTS_ISSUE_TYPE, (Object)"priority", (Object)"Major"), null, RESULTING_ISSUE_TST_3);
    }

    @Test
    @Restore(value="TestMoveIssueAutomaticAssigneeWithComponents.xml")
    public void testMoveIssueAutomaticAssigneeWithComponents() {
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            String issueKeyToMove = this.backdoor.issues().createIssue("HSP", "test move issue", "user1", "Trivial", "Bug").key();
            this.backdoor.issues().setIssueFields(issueKeyToMove, new IssueFields().environment("test environment 5").description("test description to be moved to another project").components(new ResourceRef[]{ResourceRef.withName((String)"New Component 1")}));
            this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)ISSUE_KEY_TO_MOVE), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"NDT-1", (Object)"component", (Object)"New Component 2"), issueKeyToMove);
            String projectId = this.backdoor.project().getProjectId("NDT").toString();
            this.navigation.issue().gotoIssue(issueKeyToMove);
            this.tester.clickLink(MOVE_ISSUE_LINK);
            this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
            this.tester.submit(NEXT_GT_GT);
            this.tester.selectOption("components", "New Component 2");
            this.tester.submit(NEXT_GT_GT);
            this.tester.submit(MOVE_SUBMIT);
            this.tester.assertTextPresent("user2");
            this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"NDT-1", (Object)"component", (Object)"New Component 2"), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)ISSUE_KEY_TO_MOVE), "NDT-1");
        }
        finally {
            this.administration.project().deleteProject("homosapien");
            this.administration.project().deleteProject("neanderthal");
            this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
            this.tester.clickLink("del_test move perm scheme");
            this.tester.submit("Delete");
            this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-users");
            this.backdoor.usersAndGroups().deleteUser("user1");
            this.backdoor.usersAndGroups().deleteUser("user2");
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
    }

    public void moveOperationFunctionality(String issueKey) {
        this.logger.log((Object)"Move Operation: Test the functionality of the 'Move' operation");
        String projectId = this.backdoor.project().getProjectId("NDT").toString();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
        this.tester.submit();
        this.tester.getDialog().setWorkingForm(JIRAFORM);
        this.tester.submit();
        this.tester.assertTextPresent("New Value");
        this.tester.submit(MOVE_SUBMIT);
        this.tester.assertTextNotPresent("homosapien");
        this.tester.assertTextPresent("neanderthal");
    }

    public void moveOperationWithMoveIssuesPermission(String issueKey) {
        this.logger.log((Object)"Move Operation: Test the availability of the 'Move' Link with 'Move Issues' Permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresentWithText(MOVE_SUBMIT);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresentWithText(MOVE_SUBMIT);
    }

    public void moveOperationWithInvalidDueDate(String issueKey) {
        this.editIssueFieldVisibility.setDueDateToRequried();
        this.logger.log((Object)"Move Operation: selecting invalid due date");
        String projectId = this.backdoor.project().getProjectId("MKY").toString();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.assertTextPresent("Move Issue");
        this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
        this.tester.submit();
        this.tester.setFormElement("duedate", "stuff");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
        this.editIssueFieldVisibility.resetFields();
    }

    public void moveOperationWithDueDateRequired(String issueKey) {
        this.editIssueFieldVisibility.setDueDateToRequried();
        this.logger.log((Object)"Move Operation: testing the availabilty of the 'Due Date' field with 'Due Date' required");
        String projectId = this.backdoor.project().getProjectId("MKY").toString();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.assertTextPresent("Move Issue");
        this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
        this.tester.submit();
        this.tester.assertFormElementPresent("duedate");
        this.editIssueFieldVisibility.resetFields();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.assertTextPresent("Move Issue");
        this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
        this.tester.submit();
        this.tester.assertFormElementNotPresent("duedate");
    }

    public void moveOperationWithRequiredFields(String issueKey) {
        this.editIssueFieldVisibility.setRequiredFields();
        this.logger.log((Object)"Move Operation: Moving issue with required fields.");
        String projectId = this.backdoor.project().getProjectId("NDT").toString();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.assertTextPresent("Move Issue");
        this.tester.setFormElement(PID_REQUEST_PARAM, projectId);
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.setWorkingForm(JIRAFORM);
        this.tester.submit();
        this.assertErrorMsgFieldRequired("Component/s", "neanderthal", "components");
        this.assertErrorMsgFieldRequired("Fix Version/s", "neanderthal", "versions");
        this.assertErrorMsgFieldRequired("Affects Version/s", "neanderthal", "versions");
        this.editIssueFieldVisibility.resetFields();
    }

    @Test
    @Restore(value="TestBulkMoveMapWorkflows.xml")
    public void testMoveWithMappingStatus() {
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"HSP-13", (Object)"summary", (Object)"bugs3", (Object)STATUS_FIELD, (Object)"Totally Open"), null, "HSP-13");
        this.navigation.issue().gotoIssue("HSP-13");
        this.tester.assertTextPresent("Totally Open");
        this.tester.clickLinkWithText(MOVE_SUBMIT);
        this.navigation.issue().selectProject("monkey");
        this.moveIssue();
        String movedIssueKey = this.backdoor.issueNavControl().getIssueKeyForSummary("bugs3");
        this.navigation.issue().gotoIssue(movedIssueKey);
        this.tester.assertTextNotPresent("Totally Open");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)STATUS_FIELD, (Object)"Open", (Object)"summary", (Object)"bugs3", (Object)"key", (Object)movedIssueKey), (Map<String, String>)ImmutableMap.of((Object)STATUS_FIELD, (Object)"Totally Open", (Object)"key", (Object)"HSP-13"), movedIssueKey);
    }

    @Test
    @Restore(value="TestMoveIssue.xml")
    public void testMoveIssueWithinProject() {
        this.navigation.issue().gotoIssue(ISSUE_KEY_TO_MOVE);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(MOVE_SUBMIT);
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Test Bug 2");
        this.tester.submit("Create");
        this.tester.assertLinkPresentWithText("HSP-3");
    }

    @Test
    @Restore(value="TestMoveIssueWithSubtasks.xml")
    public void testMoveIssueWithSubtasksBetweenProjects() {
        this.navigation.issue().gotoIssue("HSP-3");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("neanderthal", "10000_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_1_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.assertLinkPresentWithText("NDT-1");
        this.tester.clickLinkWithText("Sub-task 1");
        this.tester.assertLinkPresentWithText("NDT-2");
        this.assertions.assertLastChangeHistoryRecords("NDT-2", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Key", "HSP-4", "NDT-2"), new ExpectedChangeHistoryItem("Project", "homosapien", "neanderthal")));
        this.tester.clickLink("parent_issue_summary");
        this.tester.clickLinkWithText("Sub-task 2");
        this.tester.assertLinkPresentWithText("NDT-3");
        this.assertions.assertLastChangeHistoryRecords("NDT-3", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Key", "HSP-5", "NDT-3"), new ExpectedChangeHistoryItem("Project", "homosapien", "neanderthal")));
        this.navigation.issue().goToCreateIssueForm("homosapien", null);
        this.tester.setFormElement("summary", "Test Bug 3");
        this.tester.submit("Create");
        this.tester.assertLinkPresentWithText("HSP-6");
        this.navigation.issue().goToCreateIssueForm("neanderthal", null);
        this.tester.setFormElement("summary", "Test Bug 4");
        this.tester.submit("Create");
        this.tester.assertLinkPresentWithText("NDT-4");
    }

    @Test
    @Restore(value="jra-14416-workflows.xml")
    public void testMoveSubtaskWithDifferentWorkflowAndStatuses() {
        this.navigation.issue().gotoIssue("AA-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("B", "10000_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_1_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.assertTextPresent("Map Status for Target Project 'B'");
        this.tester.assertTextPresent("Step 1 of 2");
        this.tester.selectOption("3", "Three");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue("BB-2");
        this.tester.assertTextPresent("Three");
        MatcherAssert.assertThat(this.workflowUtil.queryAvailableWorkflowActionNames("BB-2"), (Matcher)Matchers.contains((Object[])new String[]{"Go To Fourth Step"}));
        this.tester.clickLink(CHANGE_HISTORY_LINK_ID);
        this.assertions.assertNewestChangeHistoryRecord("BB-2", "admin", Arrays.asList(new ExpectedChangeHistoryItem("Key", "AA-2", "BB-2"), new ExpectedChangeHistoryItem(PROJECT_FIELD, "A", "B"), new ExpectedChangeHistoryItem("Workflow", "classic default workflow", "B"), new ExpectedChangeHistoryItem(STATUS_FIELD, "In Progress", "Three")));
    }

    @Test
    @Restore(value="jra-14416-statuses.xml")
    public void testMoveSubtaskWithDifferentWorkflows() {
        this.navigation.issue().gotoIssue("AA-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("B", "10000_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_1_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue("BB-2");
        this.tester.assertTextPresent("Sub-task");
        this.tester.assertTextPresent("In Progress");
        MatcherAssert.assertThat(this.workflowUtil.queryAvailableWorkflowActionNames("BB-2"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Mark As Complete"}));
        this.tester.clickLink(CHANGE_HISTORY_LINK_ID);
        this.assertions.assertNewestChangeHistoryRecord("BB-2", "admin", Arrays.asList(new ExpectedChangeHistoryItem("Key", "AA-2", "BB-2"), new ExpectedChangeHistoryItem(PROJECT_FIELD, "A", "B"), new ExpectedChangeHistoryItem("Workflow", "jira", "B")));
    }

    @Test
    @Restore(value="jra-14416.xml")
    public void testMoveIssueWithSubtaskIssueTypesBetweenProjects() {
        this.navigation.issue().gotoIssue("AL-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("Baloney", "10000_7_pid");
        this.navigation.issue().selectIssueType("Issue Type Bentley", "10000_7_issuetype");
        this.tester.submit(NEXT);
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.textAssertions.assertTextPresent("Subtask Apple");
        this.textAssertions.assertTextPresent("Subtask Asterisk");
        this.navigation.issue().selectIssueType("Subtask Bacon", "10000_6_10001_10000_issuetype");
        this.navigation.issue().selectIssueType("Subtask Butter", "10000_9_10001_10000_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.tester.assertTextPresent("Workflow Brown");
            this.tester.selectOption("10000", "B-Status-2");
            this.tester.submit(NEXT);
            this.tester.submit(NEXT);
            this.tester.submit(NEXT);
            this.tester.submit(NEXT);
            this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.navigation.issue().gotoIssue("BA-2");
        this.tester.assertTextPresent("Subtask Bacon");
        MatcherAssert.assertThat(this.workflowUtil.queryAvailableWorkflowActionNames("BA-2"), (Matcher)Matchers.contains((Object[])new String[]{"Goto Hajime"}));
        this.tester.clickLink(CHANGE_HISTORY_LINK_ID);
        this.assertions.assertNewestChangeHistoryRecord("BA-2", "admin", Arrays.asList(new ExpectedChangeHistoryItem("Key", "AL-2", "BA-2"), new ExpectedChangeHistoryItem("issuetype", "Subtask Apple", "Subtask Bacon"), new ExpectedChangeHistoryItem(PROJECT_FIELD, "Alabaster", "Baloney"), new ExpectedChangeHistoryItem("Fix Version", "1.5", null), new ExpectedChangeHistoryItem("Version", "1.5", null), new ExpectedChangeHistoryItem("Workflow", "Workflow Astaire", "Workflow Brown"), new ExpectedChangeHistoryItem(STATUS_FIELD, "A-Status-1", "B-Status-2"), new ExpectedChangeHistoryItem("Text A", "custom text field data goes here.", ""), new ExpectedChangeHistoryItem("Component", "Comp A", null), new ExpectedChangeHistoryItem("assignee", "User A", "admin")));
        this.navigation.issue().gotoIssue("BA-3");
        this.tester.assertTextPresent("Subtask Butter");
        this.assertions.assertNewestChangeHistoryRecord("BA-3", "admin", Arrays.asList(new ExpectedChangeHistoryItem("Key", "AL-3", "BA-3"), new ExpectedChangeHistoryItem("issuetype", "Subtask Asterisk", "Subtask Butter"), new ExpectedChangeHistoryItem(PROJECT_FIELD, "Alabaster", "Baloney")));
    }

    @Test
    @Restore(value="TestReindexingSubtasks.xml")
    public void testMoveIssueWithSubtasksBetweenProjectsWithSecurityLevel() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issue().gotoIssue("RAT-5");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level", "Level Mouse");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10022_1_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.assertTextPresent("The value of this field must be changed to be valid in the target project");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Target Project", "Porcine", "Target Issue Type", "Bug", "Security Level", "None");
        this.tester.submit(NEXT);
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Porcine");
        this.tester.assertTextNotPresent("Rattus");
        this.tester.assertTextNotPresent("RAT-");
        this.tester.assertTextNotPresent("Level Mouse");
        this.navigation.issue().gotoIssue("PIG-11");
        this.tester.assertTextNotPresent("Security Level");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextNotPresent("RAT-");
        this.tester.assertTextNotPresent("Level Mouse");
        WebTable issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 1, "PIG-11");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 11, "");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 1, "PIG-10");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 11, "");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 1, "PIG-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 11, "");
        this.navigation.issue().gotoIssue("PIG-9");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("Canine", "10021_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10021_1_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.selectOption("security", "Level Green");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Target Project", "Canine", "Target Issue Type", "Bug", "Security Level", "Level Green");
        this.tester.submit(NEXT);
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextNotPresent("PIG");
        this.tester.assertTextNotPresent("Porcine");
        this.tester.assertTextPresent("Canine");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Level Green");
        this.navigation.issue().gotoIssue("DOG-11");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Level Green");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextNotInTable("issuetable", "PIG");
        issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 1, "DOG-11");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 11, "Level Green");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 1, "DOG-10");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 11, "Level Green");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 1, "DOG-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 11, "Level Green");
    }

    @Test
    @Restore(value="TestMoveIssueWithoutVersionPermission.xml")
    public void testMoveIssueWithoutVersionPermission() {
        this.navigation.issue().gotoIssue(ISSUE_KEY_TO_MOVE);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey");
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(NEXT_GT_GT);
        int lastRow = this.tester.getDialog().getWebTableBySummaryOrId("move_confirm_table").getRowCount() - 1;
        WebTable moveConfirmTable = this.tester.getDialog().getWebTableBySummaryOrId("move_confirm_table");
        this.assertions.getTableAssertions().assertTableCellHasText(moveConfirmTable, 1, 1, "homosapien");
        this.assertions.getTableAssertions().assertTableCellHasText(moveConfirmTable, 1, 2, "monkey");
        this.assertions.getTableAssertions().assertTableCellHasText(moveConfirmTable, lastRow, 1, "New Version 1");
        this.assertions.getTableAssertions().assertTableCellHasText(moveConfirmTable, lastRow, 1, "New Version 4");
        this.assertions.getTableAssertions().assertTableCellDoesNotHaveText(moveConfirmTable, lastRow, 2, "New Version 1");
        this.assertions.getTableAssertions().assertTableCellDoesNotHaveText(moveConfirmTable, lastRow, 2, "New Version 4");
        this.tester.submit(MOVE_SUBMIT);
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextNotPresent("New Version 1");
        this.tester.assertTextNotPresent("New Version 4");
    }

    @Test
    @Restore(value="TestMoveLabels.xml")
    public void testMoveIssueWithRequiredLabels() {
        this.navigation.issue().viewIssue("HSP-10");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey");
        this.tester.submit(NEXT_GT_GT);
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.assertTextPresent("Labels");
        this.tester.submit(NEXT_GT_GT);
        this.tester.assertTextPresent("Labels is required");
        this.navigation.issue().viewIssue("HSP-9");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey");
        this.tester.submit(NEXT_GT_GT);
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.assertTextPresent("All fields will be updated automatically");
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(MOVE_SUBMIT);
        this.tester.assertTextPresent("MKY-8");
        this.navigation.issue().viewIssue("HSP-8");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.assertTextPresent("Update Fields");
        this.tester.assertTextPresent("All field values will be retained");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.assertTextPresent("Labels is required");
    }

    @Test
    @Restore(value="JRA-17312.xml")
    public void testMoveIssueWithSubtasksAndComponents() {
        this.navigation.issue().viewIssue("TWO-1");
        this.tester.assertTextPresent("Date Custom Field:");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("ONE", "10001_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10001_1_issuetype");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.tester.selectOption("components_10001", "comp-one");
        this.tester.submit(NEXT);
        this.tester.selectOption("components_10001", "comp-one");
        this.tester.submit(NEXT);
        this.tester.submit(NEXT);
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue("ONE-3");
        this.tester.assertTextNotPresent("Date Custom Field:");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Component/s", "comp-one"});
        this.tester.assertTextPresent("Due:");
        this.navigation.issue().viewIssue("ONE-3");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Component/s", "comp-one"});
        this.tester.assertTextPresent("Due:");
    }

    @Test
    @Restore(value="JRA-12479.xml")
    public void testMoveIssueWithRequiredCustomFields() {
        this.navigation.issue().viewIssue("ONE-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("TWO");
        this.tester.submit(NEXT_GT_GT);
        this.tester.setFormElement("customfield_10100", "Hello World!");
        this.tester.submit(NEXT_GT_GT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"More Summary CF", "Hello World!"});
    }

    @Test
    @Restore(value="TestMoveIssue.xml")
    public void testMoveIssueRetainInactiveAssigee() {
        String targetProject = this.backdoor.project().getProjectId("NDT").toString();
        String assignee = "user1";
        this.backdoor.usersAndGroups().addUser("user1");
        this.backdoor.usersAndGroups().addUserToGroup("user1", "jira-developers");
        this.backdoor.issues().setIssueFields(ISSUE_KEY_NORMAL, new IssueFields().assignee(ResourceRef.withName((String)"user1")));
        this.backdoor.userManager().setActive("user1", false);
        Assert.assertTrue((boolean)this.issuesInProject("NDT").isEmpty());
        this.navigation.issue().viewIssue(ISSUE_KEY_NORMAL);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.setFormElement(PID_REQUEST_PARAM, targetProject);
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(MOVE_SUBMIT);
        Issue movedIssue = this.issuesInProject("NDT").iterator().next();
        Assert.assertEquals((Object)"user1", (Object)movedIssue.fields.assignee.name);
    }

    @Test
    @Restore(value="TestMoveIssue.xml")
    public void testExcludeUserWithoutPermissionAsAssigneeSuggestion() {
        String assignee = "user1";
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.usersAndGroups().addUser("user1");
        long permissionScheme = this.backdoor.permissionSchemes().copyDefaultScheme("monkey-scheme");
        this.backdoor.project().setPermissionScheme(this.backdoor.project().getProjectId("MKY"), permissionScheme);
        this.backdoor.permissionSchemes().addUserPermission(permissionScheme, ProjectPermissions.ASSIGNABLE_USER, "user1");
        String issueKeyToMove = this.backdoor.issues().createIssue("MKY", "test move issue", "user1").key();
        this.navigation.issue().viewIssue(issueKeyToMove);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.setFormElement(PID_REQUEST_PARAM, this.backdoor.project().getProjectId("HSP").toString());
        this.tester.submit(NEXT_GT_GT);
        this.tester.assertTextPresent("Move Issue: Update Fields");
        List<String> options = TestMoveIssue.selectOptions(this.tester.getDialog().getElement("assignee"));
        MatcherAssert.assertThat(options, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"user1")));
    }

    private static List<Node> listNodes(NodeList nodeList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            builder.add((Object)nodeList.item(i));
        }
        return builder.build();
    }

    private static List<String> selectOptions(Element element) {
        Preconditions.checkArgument((boolean)"select".equalsIgnoreCase(element.getNodeName()));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node node : TestMoveIssue.listNodes(element.getElementsByTagName("option"))) {
            builder.add((Object)node.getAttributes().getNamedItem("value").getNodeValue());
        }
        return builder.build();
    }

    private List<Issue> issuesInProject(String projectKey) {
        SearchRequest request = new SearchRequest().jql(String.format("project = %s", projectKey));
        return this.backdoor.search().getSearch((SearchRequest)request).issues;
    }

    private void moveIssue() {
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(NEXT_GT_GT);
        this.tester.submit(MOVE_SUBMIT);
    }

    private void assertErrorMsgFieldRequired(String fieldId, String project, String fieldDisplayName) {
        this.tester.assertTextPresent("&quot;" + fieldId + "&quot; field is required and the project &quot;" + project + "&quot; does not have any " + fieldDisplayName);
    }
}

