/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUES, Category.MOVE_ISSUE})
@LoginAs(user="admin")
public class TestMoveIssueAndRemoveFields
extends BaseJiraFuncTest {
    private String subtaskIcon;
    private String minorIcon = "/images/icons/priorities/minor.svg";
    private String taskIcon;
    private String bugIcon;
    private String blockerIcon = "/images/icons/priorities/blocker.svg";
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestMoveIssueAndRemoveFieldsEnterprise.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        IssueTypeUrls urls = IssueTypeUrls.init(this.backdoor);
        this.subtaskIcon = urls.getIssueTypeUrl("sub-task");
        this.taskIcon = urls.getIssueTypeUrl("task");
        this.bugIcon = urls.getIssueTypeUrl("bug");
    }

    @Test
    public void testMoveIssueType() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-13");
        this.textAssertions.assertTextPresent(this.locator.id("key-val"), "RAT-13");
        this.textAssertions.assertTextPresent(this.locator.id("priority-val"), "Minor");
        this.textAssertions.assertTextPresent(this.locator.id("versions-val"), "v1.0");
        this.textAssertions.assertTextPresent(this.locator.id("fixfor-val"), "v1.1");
        this.textAssertions.assertTextPresent(this.locator.id("security-val"), "Level KingRat");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.tester.assertTextPresent("Select Project and Issue Type");
        this.navigation.issue().selectIssueType("Task", "10022_1_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issue");
        this.tester.assertTextPresent("Update Fields for Target Project");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issue");
        this.tester.assertTextPresent("Please confirm that the correct changes have been entered");
        WebTable checkedTable = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(checkedTable, "Target Issue Type", "Task");
        this.assertTableHasMatchingRow(checkedTable, "Target Project", "Rattus");
        checkedTable = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(checkedTable, "Fix Version/s");
        this.assertTableHasMatchingRow(checkedTable, "Affects Version/s");
        this.assertTableHasMatchingRow(checkedTable, "Security Level");
        this.assertTableHasMatchingRow(checkedTable, "Priority");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.textAssertions.assertTextPresent(this.locator.id("key-val"), "RAT-13");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Mahatma Gandhi");
        Assert.assertTrue((this.locator.id("priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.locator.id("fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.locator.id("versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.locator.id("security-val").getNodes().length == 0 ? 1 : 0) != 0);
        Long projectId = this.backdoor.project().getProjectId("RAT");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Hidden Treasure FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
        this.navigation.issue().gotoIssue("RAT-13");
        this.textAssertions.assertTextPresent(this.locator.id("key-val"), "RAT-13");
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Mahatma Gandhi");
        Assert.assertTrue((this.locator.id("priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.locator.id("security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.textAssertions.assertTextPresent(this.locator.id("versions-val"), "None");
        this.textAssertions.assertTextPresent(this.locator.id("fixfor-val"), "None");
        this.navigation.issue().gotoIssue("RAT-14");
        this.textAssertions.assertTextPresent(this.locator.id("key-val"), "RAT-14");
        this.textAssertions.assertTextPresent(this.locator.id("priority-val"), "Minor");
        this.textAssertions.assertTextPresent(this.locator.id("versions-val"), "v1.0");
        this.textAssertions.assertTextPresent(this.locator.id("fixfor-val"), "v1.1");
        Assert.assertTrue((this.locator.id("security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        WebTable issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 1, "RAT-13");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 2, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 12).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 14).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 1, "RAT-12");
        Assert.assertEquals((Object)"asdf", (Object)issueTable.getCellAsText(3, 12).trim());
    }

    @Test
    public void testMoveIssueTypeOnSubtask() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-14");
        this.tester.clickLink("move-subtask");
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 2 of 4");
        this.tester.assertTextPresent("Choose the sub-task type to move to ...");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextPresent("Update the fields of the sub-task to relate to the new sub-task type.");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 4 of 4");
        this.tester.assertTextPresent("Confirm the move with all of the details you have just configured.");
        WebTable table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Sub-task", "Limited Subtask");
        this.tester.assertTextNotPresent("Security Level");
        this.assertTableHasMatchingRow(table, "Affects Version/s", "v1.0", "");
        this.assertTableHasMatchingRow(table, "Fix Version/s", "v1.1", "");
        this.assertTableHasMatchingRow(table, "Priority", "Minor", "");
        this.tester.submit("Move");
        this.tester.assertTextPresent("RAT-14");
        Assert.assertThat((Object)this.tester.getDialog().getElement("issuedetails").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Security")));
        this.textAssertions.assertTextNotPresent(this.locator.id("issuedetails"), "Random Shit");
        this.textAssertions.assertTextNotPresent(this.locator.id("issuedetails"), "Priority");
        this.textAssertions.assertTextNotPresent(this.locator.id("issuedetails"), "Fix Version");
        this.textAssertions.assertTextNotPresent(this.locator.id("issuedetails"), "Affects Version");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.navigation.issue().gotoIssue("RAT-14");
        this.textAssertions.assertTextPresent(this.locator.id("key-val"), "RAT-14");
        this.textAssertions.assertTextPresent(this.locator.id("versions-val"), "None");
        this.textAssertions.assertTextPresent(this.locator.id("fixfor-val"), "None");
        this.textAssertions.assertTextPresent(this.locator.id("security-val"), "Level KingRat");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(this.tester.getDialog().getWebTableBySummaryOrId("issuetable"), 1, 1, "RAT-14");
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(1, 11).trim());
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals(""));
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals(""));
    }

    @Test
    public void testMoveProject() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-13");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-13");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "versions-val"), "v1.0");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "v1.1");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level KingRat");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.tester.assertTextPresent("Select Project and Issue Type");
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issue");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issue");
        this.tester.assertTextPresent("Update Fields for Target Project");
        this.tester.submit("Next");
        this.tester.submit("Next");
        WebTable checkedTable = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(checkedTable, "Target Issue Type", "Bug");
        this.assertTableHasMatchingRow(checkedTable, "Target Project", "Porcine");
        checkedTable = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(checkedTable, "Fix Version/s");
        this.assertTableHasMatchingRow(checkedTable, "Affects Version/s");
        this.assertTableHasMatchingRow(checkedTable, "Security Level");
        this.assertTableHasMatchingRow(checkedTable, "Priority");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-15");
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        Long projectId = this.backdoor.project().getProjectId("PIG");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Bug is Limited FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
        this.navigation.issue().gotoIssue("PIG-15");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-15");
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.navigation.issue().gotoIssue("PIG-16");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-16");
        Assert.assertThat((Object)this.tester.getDialog().getElement("issuedetails").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Security")));
        this.tester.assertTextNotPresent("Level KingRat");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 4, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(this.tester.getDialog().getWebTableBySummaryOrId("issuetable"), 4, 1, "PIG-16");
        this.assertTableCellHasImageInContext(issueTable, 4, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(4, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(4, 12).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(4, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 5, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(this.tester.getDialog().getWebTableBySummaryOrId("issuetable"), 5, 1, "PIG-15");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 5, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(5, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(5, 12).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(5, 13).trim());
    }

    @Test
    public void testBulkMoveIssueType() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        WebTable issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 1, "RAT-12");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, this.blockerIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 13, "v0.9");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 14, "v0.1");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.checkCheckbox("bulkedit_10040", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.assertTextPresent("Choose the operation you wish to perform on the selected <strong>2</strong> issue(s)");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectIssueType("Task", "10022_1_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Task'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Rattus");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Task");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Random Shit");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Security Level");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 1, "RAT-13");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 2, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 14).trim());
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 1, "RAT-12");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 3, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 14).trim());
        Long projectId = this.backdoor.project().getProjectId("RAT");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Hidden Treasure FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
        this.navigation.issueNavigator().displayAllIssues();
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-13");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 2, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 14).trim());
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-12");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 3, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 14).trim());
    }

    @Test
    public void testBulkMoveIssueTypeOnSubtask() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 14, "v1.0");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10060", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectIssueType("Limited Subtask", "10022_5_10022_10050_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Limited Subtask'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        this.tester.assertTextPresent("Step 4 of 4");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        Assert.assertThat((Object)this.tester.getDialog().getElement("bulkedit").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Security")));
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 1, 5);
        this.assertTableCellHasNoText(issueTable, 1, 11);
        this.assertTableCellHasNoText(issueTable, 1, 13);
        this.assertTableCellHasNoText(issueTable, 1, 14);
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 14, "v1.0");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.navigation.issueNavigator().displayAllIssues();
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 1, 5);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertTableCellHasNoText(issueTable, 1, 13);
        this.assertTableCellHasNoText(issueTable, 1, 14);
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 14, "v1.0");
    }

    @Test
    public void testBulkMoveProject() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-13");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 2, "Uncle Matty");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, this.minorIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-12");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "One of them is \"Fatty\"");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, this.blockerIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 13, "v0.9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 14, "v0.1");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10040", "on");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.assertTextPresent("Choose the operation you wish to perform on the selected <strong>2</strong> issue(s)");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues");
        this.tester.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Bug'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues");
        this.tester.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Sub-task'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Porcine");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Bug");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Random Shit");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Security Level");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        issueTable = this.getTable("issuetable");
        int rowNum = this.findIssueRowNum(issueTable, "Uncle Matty");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 1, "PIG-1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 2, "Uncle Matty");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, rowNum, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 14).trim());
        rowNum = this.findIssueRowNum(issueTable, "One of them is \"Fatty\"");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 1, "PIG-1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 2, "One of them is \"Fatty\"");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, rowNum, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 14).trim());
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "PIG-17");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "Get Uncle Matty a new Leg");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 14).trim());
        Long projectId = this.backdoor.project().getProjectId("PIG");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Bug is Limited FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
        this.navigation.issueNavigator().displayAllIssues();
        issueTable = this.getTable("issuetable");
        rowNum = this.findIssueRowNum(issueTable, "Uncle Matty");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 1, "PIG-1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 2, "Uncle Matty");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, rowNum, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 14).trim());
        rowNum = this.findIssueRowNum(issueTable, "One of them is \"Fatty\"");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, this.bugIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 1, "PIG-1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, rowNum, 2, "One of them is \"Fatty\"");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, rowNum, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(rowNum, 14).trim());
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "PIG-17");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "Get Uncle Matty a new Leg");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 14).trim());
        this.navigation.issue().gotoIssue("PIG-15");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-15");
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.navigation.issue().gotoIssue("PIG-17");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-17");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
    }

    private int findIssueRowNum(WebTable issueTable, String key) {
        for (int rowNum = 0; rowNum < issueTable.getRowCount(); ++rowNum) {
            if (!key.equals(issueTable.getCellAsText(rowNum, 2).trim())) continue;
            return rowNum;
        }
        return -1;
    }

    @Test
    public void testBulkMigrate_AltersIssue() throws SAXException {
        Long projectId = this.backdoor.project().getProjectId("RAT");
        this.navigation.gotoAdmin();
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.assertTextPresent("Select Issue Type Scheme for project Rattus");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugless Scheme");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration: Overview (Step 1 of 4)");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Issue Type Migration: Select Issue Type (Step 2 of 4)");
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Issue Type Migration: Update Fields (Step 3 of 4)");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Issue Type Migration: Confirmation (Step 4 of 4)");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Rattus");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Task");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Random Shit");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Security Level");
        this.tester.submit("nextBtn");
        if (this.tester.getDialog().getResponsePageTitle().contains("Bulk Operation")) {
            this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        }
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).issueTypeScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Bugless Scheme"));
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Hidden Treasure FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, this.minorIcon);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 13, "v1.1");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 14, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-13");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 2, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 14).trim());
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-12");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 3, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 13).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 14).trim());
        this.navigation.issue().gotoIssue("RAT-13");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-13");
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.navigation.issue().gotoIssue("RAT-14");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "versions-val"), "v1.0");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "v1.1");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBulkMigrate_AltersSubtask() throws SAXException {
        Long projectId = this.backdoor.project().getProjectId("RAT");
        this.navigation.gotoAdmin();
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.assertTextPresent("Select Issue Type Scheme for project Rattus");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "No Subtask Scheme");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Overview (Step 1 of 4)");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Select Issue Type (Step 2 of 4)");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Update Fields (Step 3 of 4)");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Confirmation (Step 4 of 4)");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Rattus");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Limited Subtask");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.tester.assertTextNotPresent("Security Level");
        Assert.assertEquals((String)"Too many rows in the removed_fields_table: Are we including Security Level?", (long)4L, (long)removed_fields_table.getRowCount());
        this.tester.submit("nextBtn");
        if (this.tester.getDialog().getResponsePageTitle().contains("Bulk Operation")) {
            this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        }
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).issueTypeScheme.name, (Matcher)CoreMatchers.equalTo((Object)"No Subtask Scheme"));
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Hidden Treasure FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 1, 5);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertTableCellHasNoText(issueTable, 1, 12);
        this.assertTableCellHasNoText(issueTable, 1, 13);
        this.navigation.issue().gotoIssue("RAT-14");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level KingRat");
    }

    @Test
    public void testConvertSubtaskToIssue() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-14");
        this.tester.clickLink("subtask-to-issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Confirm the conversion with all of the details you have just configured.");
        WebTable table = this.getTable("convert_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Sub-task", "Task");
        this.assertTableHasMatchingRow(table, "Affects Version/s", "v1.0", "");
        this.assertTableHasMatchingRow(table, "Fix Version/s", "v1.1", "");
        this.assertTableHasMatchingRow(table, "Security Level", "Level KingRat", "");
        this.assertTableHasMatchingRow(table, "Priority", "Minor", "");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.changeProjectRatToDefaultFieldConfiguration();
        this.navigation.issue().gotoIssue("RAT-14");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.taskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertions.getTableAssertions().assertTableCellHasNoImage(issueTable, 1, 5);
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals(""));
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals(""));
    }

    @Test
    public void testConvertIssueToSubtaskOfIssueWithNoSecurity() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-12");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("Level KingRat");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "RAT-10");
        this.navigation.issue().selectIssueType("Limited Subtask", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Convert Issue to Sub-task: RAT-12");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        WebTable table = this.getTable("convert_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Bug", "Limited Subtask");
        this.assertTableHasMatchingRow(table, "Security Level", "Level KingRat", "None");
        this.assertTableHasMatchingRow(table, "Random Shit", "asdf", "");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.changeProjectRatToDefaultFieldConfiguration();
        this.navigation.issue().gotoIssue("RAT-12");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-12");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertTrue((boolean)issueTable.getCellAsText(3, 12).trim().equals(""));
        Assert.assertTrue((boolean)issueTable.getCellAsText(3, 13).trim().equals(""));
    }

    @Test
    public void testConvertIssueToSubtaskOfIssueWithSecurity() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-12");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("Level KingRat");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "RAT-11");
        this.navigation.issue().selectIssueType("Limited Subtask", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Convert Issue to Sub-task: RAT-12");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        WebTable table = this.getTable("convert_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Bug", "Limited Subtask");
        this.assertTableHasMatchingRow(table, "Security Level", "Level KingRat", "Level Mouse");
        this.assertTableHasMatchingRow(table, "Affects Version/s", "v0.1", "");
        this.assertTableHasMatchingRow(table, "Fix Version/s", "v0.9", "");
        this.assertTableHasMatchingRow(table, "Priority", "Blocker", "");
        this.assertTableHasMatchingRow(table, "Random Shit", "asdf", "");
        Assert.assertEquals((String)"Too many rows in summary table - is Security level listed twice?", (long)7L, (long)table.getRowCount());
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        Assert.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new IdLocator(this.tester, "versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.tester.assertTextNotPresent("Random Shit");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.navigation.issue().gotoIssue("RAT-12");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level Mouse");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-12");
        Assert.assertEquals((Object)"Level Mouse", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertTrue((boolean)issueTable.getCellAsText(3, 12).trim().equals(""));
        Assert.assertTrue((boolean)issueTable.getCellAsText(3, 13).trim().equals(""));
    }

    @Test
    public void testMoveSubtaskToNewParentWithHiddenSecurity() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-10");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        this.navigation.issue().gotoIssue("RAT-14");
        this.tester.assertTextPresent("RAT-14");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("Level KingRat");
        this.tester.clickLink("move-subtask");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Select a new parent issue for this subtask.");
        this.tester.setFormElement("parentIssue", "RAT-10");
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("RAT-14");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextNotPresent("Level KingRat");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertTableCellHasNoText(issueTable, 1, 11);
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals("v1.1"));
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 14).trim().equals("v1.0"));
    }

    @Test
    public void testMoveSubtaskWithHiddenSecurityToNewParent() throws SAXException {
        this.navigation.issue().gotoIssue("RAT-14");
        this.tester.clickLink("move-subtask");
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Choose the sub-task type to move to");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the sub-task to relate to the new sub-task type.");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Confirm the move with all of the details you have just configured.");
        this.tester.submit("Move");
        this.tester.clickLink("move-subtask");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Select a new parent issue for this subtask.");
        this.tester.setFormElement("parentIssue", "RAT-11");
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("RAT-14");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextNotPresent("Level Mouse");
        this.tester.assertTextNotPresent("Level KingRat");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.navigation.issue().gotoIssue("RAT-14");
        this.tester.assertTextPresent("RAT-14");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("Level Mouse");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, this.subtaskIcon);
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-14");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level Mouse");
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals(""));
        Assert.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals(""));
    }

    private void assertTableCellHasNoText(WebTable webTable, int row, int column) {
        String actual = webTable.getCellAsText(row, column).trim();
        Assert.assertEquals((String)("Table cell at [" + row + ", " + column + "] was expected to have no text, but was '" + actual + "'"), (Object)"", (Object)actual);
    }

    private void changeProjectRatToDefaultFieldConfiguration() {
        Long projectId = this.backdoor.project().getProjectId("RAT");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"Hidden Treasure FC Scheme"));
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "System Default Field Configuration");
        this.tester.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).fieldConfigurationScheme.name, (Matcher)CoreMatchers.equalTo((Object)"System Default Field Configuration"));
    }

    private void assertTableHasMatchingRow(WebTable webtable, String col1) {
        this.assertions.getTableAssertions().assertTableContainsRow(webtable, new String[]{col1});
    }

    private void assertTableHasMatchingRow(WebTable webtable, String col1, String col2) {
        this.assertions.getTableAssertions().assertTableContainsRow(webtable, new String[]{col1, col2});
    }

    private void assertTableHasMatchingRow(WebTable webtable, String col1, String col2, String col3) {
        this.assertions.getTableAssertions().assertTableContainsRow(webtable, new String[]{col1, col2, col3});
    }

    protected void assertTableCellHasImageInContext(WebTable table, int row, int col, String path) {
        String fullPath = LocalTestEnvironmentData.DEFAULT.getContext() + path;
        this.assertions.getTableAssertions().assertTableCellHasImage(table, row, col, fullPath);
    }

    private WebTable getTable(String tableID) throws SAXException {
        return this.tester.getDialog().getResponse().getTableWithID(tableID);
    }
}

