/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Session;
import com.atlassian.jira.functest.framework.SessionFactory;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.MOVE_ISSUE})
@Restore(value="TestMoveIssueAttachment.xml")
@LoginAs(user="admin")
public class TestMoveIssueAttachment
extends BaseJiraFuncTest {
    public static final String COW_15_ATTACHMENT = "COW/10000/COW-15/10010";
    public static final String DOG_1_ATTACHMENT = "DOG/10000/DOG-1/10010";
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private Administration administration;
    @Inject
    private SessionFactory sessionFactory;

    @Before
    public void setUpTest() {
        this.administration.attachments().enable();
    }

    @Test
    public void testMoveSingleIssueSameWorkflow() throws Exception {
        this.installAttachedFile("AAAAAA");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("AAAAAA");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Bovine");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("AAAAAA");
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
        this.deleteAttachment("COW-15");
        Assert.assertFalse((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
    }

    @Test
    public void testMoveSingleIssueDifferentWorkflow() throws Exception {
        this.installAttachedFile("testMo");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Step 1 of 4");
        this.navigation.issue().selectProject("Canine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.submit("Move");
        this.tester.assertTextPresent("DOG-1");
        this.navigation.issue().viewIssue("DOG-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testMo");
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(DOG_1_ATTACHMENT));
        this.deleteAttachment("DOG-1");
        Assert.assertFalse((boolean)this.backdoor.attachmentFile().fileExists(DOG_1_ATTACHMENT));
    }

    @Test
    public void testBulkMoveIssueSameWorkflow() throws Exception {
        this.installAttachedFile("testBu");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("Bovine", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage(this.tester);
        this.navigation.issue().viewIssue("COW-15");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testBu");
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
        this.deleteAttachment("COW-15");
        Assert.assertFalse((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
    }

    @Test
    public void testBulkMoveIssueDifferentWorkflow() throws Exception {
        this.installAttachedFile("testBu");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("Canine", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage(this.tester);
        this.navigation.issue().viewIssue("DOG-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testBu");
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(DOG_1_ATTACHMENT));
        this.deleteAttachment("DOG-1");
        Assert.assertFalse((boolean)this.backdoor.attachmentFile().fileExists(DOG_1_ATTACHMENT));
    }

    @Test
    public void testMoveSingleIssueTwoUsers() throws Exception {
        this.installAttachedFile("WWWWww");
        Session otherUser = this.sessionFactory.begin();
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        otherUser.withSession(() -> {
            this.navigation.login("admin");
            this.navigation.issue().viewIssue("RAT-1");
            this.tester.clickLink("move-issue");
        });
        this.navigation.issue().selectProject("Bovine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.submit("Next >>");
        otherUser.withSession(() -> {
            this.navigation.issue().selectProject("Canine");
            this.tester.submit("Next >>");
            this.tester.assertTextPresent("Step 3 of 4");
            this.tester.submit("Next >>");
            this.tester.assertTextPresent("Move Issue: Confirm");
            this.tester.submit("Move");
            this.tester.assertTextPresent("DOG-1");
            this.tester.clickLinkWithText("info.txt");
            this.tester.assertTextPresent("WWWWww");
        });
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.assertTextPresent("Cannot move Issue RAT-1 because it has already been moved to DOG-1.");
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(DOG_1_ATTACHMENT));
        this.deleteAttachment("DOG-1");
        Assert.assertFalse((boolean)this.backdoor.attachmentFile().fileExists(DOG_1_ATTACHMENT));
    }

    @Test
    public void testBulkMoveIssueTwoUsers() throws Exception {
        this.installAttachedFile("JJJJJJ");
        Session otherUser = this.sessionFactory.begin();
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Canine", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        otherUser.withSession(() -> {
            this.navigation.login("admin");
            this.navigation.issueNavigator().bulkEditAllIssues();
            this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
            this.tester.checkCheckbox("bulkedit_10000", "on");
            this.tester.submit("Next");
            this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
            this.tester.checkCheckbox("operation", "bulk.move.operation.name");
            this.tester.submit("Next");
            this.tester.assertTextPresent("Select Projects and Issue Types");
            this.navigation.issue().selectProject("Bovine", "10000_1_pid");
            this.tester.submit("Next");
            this.tester.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Bug'");
            this.tester.submit("Next");
            this.tester.assertTextPresent("Confirmation");
            this.tester.submit("Next");
            this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
            this.tester.assertTextPresent("Issue Navigator");
            this.navigation.issue().viewIssue("COW-15");
            this.tester.clickLinkWithText("info.txt");
            this.tester.assertTextPresent("JJJJJJ");
        });
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        this.tester.assertTextPresent("At least one of the issues you are trying to move has been recently moved by another user (RAT-1). Please cancel and start again.");
        Assert.assertTrue((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
        this.deleteAttachment("COW-15");
        Assert.assertFalse((boolean)this.backdoor.attachmentFile().fileExists(COW_15_ATTACHMENT));
    }

    private void installAttachedFile(String contents) {
        this.backdoor.attachmentFile().createAttachment("RAT/RAT-1/10010", contents);
    }

    private void deleteAttachment(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("manage-attachment-link");
        this.tester.clickLink("del_10010");
        this.tester.submit("Delete");
    }
}

