/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.WorkflowSchemes;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.MOVE_ISSUE})
@Restore(value="TestMoveIssueWithIssueSecurityLevel.xml")
@LoginAs(user="admin")
public class TestMoveIssueForEnterprise
extends BaseJiraFuncTest {
    private static final String MOVE_CONFIRM_TABLE = "move_confirm_table";
    private static final int CHANGE_TYPE_INDEX = 0;
    private static final int PREVIOUS_VALUE_INDEX = 1;
    private static final int NEW_VALUE_INDEX = 2;
    private static final String SPAN_TAG_END = "</span>";
    public static final String TRANSITION_ID_STATUS_APPROVED_ACTION_REOPEN = "action_id_21";
    public static final String TRANSITION_ID_STATUS_OPEN_ACTION_APPROVE = "action_id_11";
    @Inject
    private WorkflowSchemes workflowSchemes;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @After
    public void tearDown() {
        this.removeWorkflow();
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testMoveIssueWithSubtaskFromIssueSecuritySchemeToNoScheme() {
        this.navigation.issue().gotoIssue("HSP-8");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("test", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextNotPresent("Level 1");
        this.tester.assertTextPresent("subtask 1");
        this.tester.clickLinkWithText("subtask 1");
        this.tester.assertTextNotPresent("Level 1");
    }

    @Test
    public void testMoveIssueWithSubtaskFromIssueSecuritySchemeToSameScheme() {
        this.navigation.issue().gotoIssue("HSP-8");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("SameSchemeProject", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Level 1");
        this.tester.assertTextPresent("subtask 1");
        this.tester.clickLinkWithText("subtask 1");
        this.tester.assertTextPresent("Level 1");
    }

    @Test
    public void testMoveIssueWithSubtaskFromIssueSecuritySchemeToDifferentScheme() {
        this.navigation.issue().gotoIssue("HSP-8");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.selectOption("security", "Level 2");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Level 2");
        this.tester.assertTextPresent("subtask 1");
        this.tester.clickLinkWithText("subtask 1");
        this.tester.assertTextPresent("Level 2");
    }

    @Test
    public void testMoveIssueWithSubtaskFromNoSchemeToIssueSecurityScheme() {
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("monkey", "10010_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextNotPresent("Level 2");
        this.tester.assertTextPresent("subtask 2");
        this.tester.clickLinkWithText("subtask 2");
        this.tester.assertTextNotPresent("Level 2");
    }

    @Test
    public void testMoveIssueWithSubtaskFromNoSchemeToIssueSecuritySchemeRequired() {
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien", "10010_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.selectOption("security", "Level 1");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Level 1");
        this.tester.assertTextPresent("subtask 2");
        this.tester.clickLinkWithText("subtask 2");
        this.tester.assertTextPresent("Level 1");
    }

    @Test
    @Restore(value="blankWithOldDefault.xml")
    public void testMoveIssueForEnterprise() {
        this.createProjectIfAbsent("homosapien", "HSP", "admin");
        this.createProjectIfAbsent("neanderthal", "NDT", "admin");
        this.moveOperationToSameProjectAndType();
        this.moveIssueWithWorkflow();
        this.moveIssueWithMultipleWorkflowInScheme();
    }

    public void moveIssueWithMultipleWorkflowInScheme() {
        this.logger.log((Object)"Move Operation: Moving issue to a different issueType with a different workflow that has different status.");
        this.createWorkflowWithDifferentWorkflows();
        String issueKey = this.backdoor.issues().createIssue("NDT", "test moving issue between workflows", "admin", "Minor", "Bug").key();
        this.navigation.issue().gotoIssue(issueKey);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Resolved");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Select Status");
        this.tester.selectOption("beanTargetStatusId", "Approved");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.confirmChangesToBeMade("Bug", "Improvement");
        this.confirmStatusChangesToBeMade("Resolved", "Approved");
        this.confirmWorkflowMovement("Copied Workflow", "New Workflow For Testing");
        this.tester.submit("Move");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Approved", new String[0]);
        this.tester.assertLinkPresentWithText("neanderthal");
        this.workflowUtil.clickAction(TRANSITION_ID_STATUS_APPROVED_ACTION_REOPEN);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Open", new String[0]);
        this.workflowUtil.clickAction(TRANSITION_ID_STATUS_OPEN_ACTION_APPROVE);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Approved", new String[0]);
        this.navigation.issue().deleteIssue(issueKey);
    }

    private void confirmWorkflowMovement(String oldWorkflow, String newWorkFlow) {
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "(" + oldWorkflow + ")" + SPAN_TAG_END, "(" + newWorkFlow + ")" + SPAN_TAG_END);
    }

    private void confirmChangesToBeMade(String oldValue, String newValue) {
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), oldValue + SPAN_TAG_END, newValue + SPAN_TAG_END);
    }

    private void confirmStatusChangesToBeMade(String oldValue, String newValue) {
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), oldValue, newValue);
    }

    private void createWorkflowWithDifferentWorkflows() {
        this.logger.log((Object)"Creating workflow");
        this.workflowSchemes.addWorkFlowScheme("New Workflow Scheme", "Workflow scheme to test move issue");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow");
        this.administration.workflows().goTo().addWorkflow("New Workflow For Testing", "this workflow has one status Open only");
        this.administration.workflows().goTo();
        this.administration.statuses().addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.administration.workflows().goTo().workflowSteps("New Workflow For Testing").add("Approved", "Approved");
        this.administration.workflows().goTo().workflowSteps("New Workflow For Testing").addTransition("Open", "Approve Issue", "", "Approved", null);
        this.administration.workflows().goTo().workflowSteps("New Workflow For Testing").addTransition("Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.backdoor.getTestkit().workflowSchemes().assignScheme(10001L, "Bug", "Copied Workflow");
        this.backdoor.getTestkit().workflowSchemes().assignScheme(10001L, "New Feature", "Copied Workflow");
        this.backdoor.getTestkit().workflowSchemes().assignScheme(10001L, "Task", "Copied Workflow");
        this.backdoor.getTestkit().workflowSchemes().assignScheme(10001L, "Improvement", "New Workflow For Testing");
        this.administration.project().associateWorkflowScheme("neanderthal", "New Workflow Scheme");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "New Workflow Scheme");
    }

    public void moveOperationToSameProjectAndType() {
        this.logger.log((Object)"Move Operation: Test the error checking for moving an issue to the same project and issue type");
        String issueKey = this.backdoor.issues().createIssue("HSP", "test move issue", "admin", "Trivial", "Bug").key();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.tester.setFormElement("issuetype", "1");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent("You must select a different project or issue type to complete a move operation.");
    }

    public void moveIssueWithWorkflow() {
        this.logger.log((Object)"Move Operation: Moving issue to project without the same status.");
        this.createWorkflow();
        this.performMoveIssue();
        this.removeWorkflow();
    }

    private void createProjectIfAbsent(String name, String key, String lead) {
        this.administration.project().addProject(name, key, lead);
    }

    private void removeWorkflow() {
        this.logger.log((Object)"Removing workflow");
        this.createProjectIfAbsent("neanderthal", "NDT", "admin");
        this.administration.project().associateWorkflowScheme("neanderthal", "Default");
        this.workflowSchemes.deleteWorkFlowScheme("10000");
        this.administration.workflows().goTo().delete("Copied Workflow");
        this.administration.workflows().goTo().delete("New Workflow For Testing");
    }

    private void createWorkflow() {
        this.logger.log((Object)"Creating workflow");
        this.workflowSchemes.addWorkFlowScheme("New Workflow Scheme", "Workflow scheme to test move issue");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow");
        this.administration.statuses().addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").add("Approved", "Approved");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Resolved", "Approve Issue", "", "Approved", null);
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Approved", "Close Issue", "", "Closed", null);
        this.backdoor.getTestkit().workflowSchemes().assignScheme(10000L, "Bug", "Copied Workflow");
        this.administration.project().associateWorkflowScheme("neanderthal", "New Workflow Scheme");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "New Workflow Scheme");
    }

    private void performMoveIssue() {
        String issueKey = this.backdoor.issues().createIssue("NDT", "test moving issue between workflows", "admin", "Minor", "Bug").key();
        this.navigation.issue().gotoIssue(issueKey);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Resolved");
        this.workflowUtil.clickAction("action_id_711");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Select Status");
        this.tester.selectOption("beanTargetStatusId", "Open");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.checkMoveConfirmTable();
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Open");
        this.tester.assertLinkPresentWithText("homosapien");
        this.navigation.issue().deleteIssue(issueKey);
    }

    private void checkMoveConfirmTable() {
        this.tester.assertTextPresent("Move Issue: Confirm");
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID(MOVE_CONFIRM_TABLE);
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains("Status")) continue;
                String previousCell = fieldTable.getCellAsText(i, 1);
                String newCell = fieldTable.getCellAsText(i, 2);
                Assert.assertTrue((boolean)previousCell.contains("Approved"));
                Assert.assertTrue((boolean)newCell.contains("Open"));
                return;
            }
            Assert.fail((String)"Cannot find field with id 'Status'.");
        }
        catch (SAXException e) {
            Assert.fail((String)"Cannot find table with id 'move_confirm_table'.");
            e.printStackTrace();
        }
    }
}

