/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.MOVE_ISSUE})
@LoginAs(user="admin")
@Restore(value="TestMoveIssueNotifications.xml")
public class TestMoveIssueNotifications
extends EmailBaseFuncTestCase {
    private static final String ISSUE_KEY = "PONE-1";
    private static final String TEXT_ON_ISSUE_MOVED_MAIL = "moved";
    private static final String TEXT_ON_ISSUE_UPDATED_MAIL = "updated";

    @Before
    public void setUp() {
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.configureAndStartSmtpServer();
    }

    @Test
    public void testMovingIssueWithoutSubtaskSendsEmailWhenWeChangeProject() throws Exception {
        this.moveIssueToDifferentProject(ISSUE_KEY);
        this.assertEmailContainingText(TEXT_ON_ISSUE_MOVED_MAIL);
    }

    @Test
    public void testMovingIssuesWithoutSubtaskSendsEmailWhenWeDoNotChangeProject() throws Exception {
        this.changeIssueTypeKeepingItOnTheSameProject(ISSUE_KEY);
        this.assertEmailContainingText(TEXT_ON_ISSUE_UPDATED_MAIL);
    }

    private void moveIssueToDifferentProject(String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("project2");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
    }

    private void changeIssueTypeKeepingItOnTheSameProject(String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectIssueType("Task");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
    }

    private void assertEmailContainingText(String text) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient("admin@example.com");
        MatcherAssert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
        this.assertEmailBodyContains(messagesForRecipient.get(0), text);
    }
}

