/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.MOVE_ISSUE, Category.SECURITY})
@LoginAs(user="admin")
public class TestPromptUserForSecurityLevelOnBulkMove
extends BaseJiraFuncTest {
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestPromptUserForSecurityLevelOnBulkMove.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testBulkMoveIssueType_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10010", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.selectOption("security", "Developers");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'monkey' - Issue Type 'Sub-task'");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        this.tester.submit("Next");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        WebTable issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        Assert.assertEquals((String)"cell(0, 0) in table 'issuetable' should be 'T'", (Object)"T", (Object)issuetable.getCellAsText(0, 0).trim());
        Assert.assertEquals((String)"cell(0, 1) in table 'issuetable' should be 'Key'", (Object)"Key", (Object)issuetable.getCellAsText(0, 1).trim());
        Assert.assertEquals((String)"cell(0, 2) in table 'issuetable' should be 'Summary'", (Object)"Summary", (Object)issuetable.getCellAsText(0, 2).trim());
        Assert.assertEquals((String)"cell(0, 3) in table 'issuetable' should be 'Assignee'", (Object)"Assignee", (Object)issuetable.getCellAsText(0, 3).trim());
        Assert.assertEquals((String)"cell(0, 4) in table 'issuetable' should be 'Reporter'", (Object)"Reporter", (Object)issuetable.getCellAsText(0, 4).trim());
        Assert.assertEquals((String)"cell(0, 5) in table 'issuetable' should be 'P'", (Object)"P", (Object)issuetable.getCellAsText(0, 5).trim());
        Assert.assertEquals((String)"cell(0, 6) in table 'issuetable' should be 'Status'", (Object)"Status", (Object)issuetable.getCellAsText(0, 6).trim());
        Assert.assertEquals((String)"cell(0, 7) in table 'issuetable' should be 'Resolution'", (Object)"Resolution", (Object)issuetable.getCellAsText(0, 7).trim());
        Assert.assertEquals((String)"cell(0, 8) in table 'issuetable' should be 'Created'", (Object)"Created", (Object)issuetable.getCellAsText(0, 8).trim());
        Assert.assertEquals((String)"cell(0, 9) in table 'issuetable' should be 'Updated'", (Object)"Updated", (Object)issuetable.getCellAsText(0, 9).trim());
        Assert.assertEquals((String)"cell(0, 10) in table 'issuetable' should be 'Due'", (Object)"Due", (Object)issuetable.getCellAsText(0, 10).trim());
        Assert.assertEquals((String)"cell(0, 11) in table 'issuetable' should be 'Security'", (Object)"Security", (Object)issuetable.getCellAsText(0, 11).trim());
        Assert.assertEquals((String)"cell(1, 1) in table 'issuetable' should be 'MKY-10'", (Object)"MKY-10", (Object)issuetable.getCellAsText(1, 1).trim());
        Assert.assertEquals((String)"cell(1, 2) in table 'issuetable' should be 'MKY-9 Child'", (Object)"MKY-9\n                        Child", (Object)issuetable.getCellAsText(1, 2).trim());
        Assert.assertEquals((String)"cell(1, 3) in table 'issuetable' should be 'Administrator'", (Object)"Administrator", (Object)issuetable.getCellAsText(1, 3).trim());
        Assert.assertEquals((String)"cell(1, 4) in table 'issuetable' should be 'Administrator'", (Object)"Administrator", (Object)issuetable.getCellAsText(1, 4).trim());
        Assert.assertEquals((String)"cell(1, 5) in table 'issuetable' should be ''", (Object)"", (Object)issuetable.getCellAsText(1, 5).trim());
        Assert.assertEquals((String)"cell(1, 6) in table 'issuetable' should be 'Open'", (Object)"Open", (Object)issuetable.getCellAsText(1, 6).trim());
        Assert.assertEquals((String)"cell(1, 7) in table 'issuetable' should be 'Unresolved'", (Object)"Unresolved", (Object)issuetable.getCellAsText(1, 7).trim());
        Assert.assertEquals((String)"cell(1, 8) in table 'issuetable' should be '31/Jul/08'", (Object)"31/Jul/08", (Object)issuetable.getCellAsText(1, 8).trim());
        Assert.assertEquals((String)"cell(1, 10) in table 'issuetable' should be ''", (Object)"", (Object)issuetable.getCellAsText(1, 10).trim());
        Assert.assertEquals((String)"cell(1, 11) in table 'issuetable' should be 'Developers'", (Object)"Developers", (Object)issuetable.getCellAsText(1, 11).trim());
        Assert.assertEquals((String)"cell(2, 1) in table 'issuetable' should be 'MKY-9'", (Object)"MKY-9", (Object)issuetable.getCellAsText(2, 1).trim());
        Assert.assertEquals((String)"cell(2, 2) in table 'issuetable' should be 'Parent'", (Object)"Parent", (Object)issuetable.getCellAsText(2, 2).trim());
        Assert.assertEquals((String)"cell(2, 3) in table 'issuetable' should be 'Administrator'", (Object)"Administrator", (Object)issuetable.getCellAsText(2, 3).trim());
        Assert.assertEquals((String)"cell(2, 4) in table 'issuetable' should be 'Administrator'", (Object)"Administrator", (Object)issuetable.getCellAsText(2, 4).trim());
        Assert.assertEquals((String)"cell(2, 5) in table 'issuetable' should be ''", (Object)"", (Object)issuetable.getCellAsText(2, 5).trim());
        Assert.assertEquals((String)"cell(2, 6) in table 'issuetable' should be 'Open'", (Object)"Open", (Object)issuetable.getCellAsText(2, 6).trim());
        Assert.assertEquals((String)"cell(2, 7) in table 'issuetable' should be 'Unresolved'", (Object)"Unresolved", (Object)issuetable.getCellAsText(2, 7).trim());
        Assert.assertEquals((String)"cell(2, 8) in table 'issuetable' should be '31/Jul/08'", (Object)"31/Jul/08", (Object)issuetable.getCellAsText(2, 8).trim());
        Assert.assertEquals((String)"cell(2, 10) in table 'issuetable' should be ''", (Object)"", (Object)issuetable.getCellAsText(2, 10).trim());
        Assert.assertEquals((String)"cell(2, 11) in table 'issuetable' should be 'Developers'", (Object)"Developers", (Object)issuetable.getCellAsText(2, 11).trim());
        this.tester.clickLinkWithText("MKY-10");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("Developers");
    }
}

