/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.MOVE_ISSUE})
@LoginAs(user="admin")
@Restore(value="TestRedirectToMovedIssues.xml")
public class TestRedirectToMovedIssues
extends BaseJiraFuncTest {
    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testRedirectToMovedIssueXML() {
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/MKY-1/MKY-1.xml");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/si/jira.issueviews:issue-xml/HSP-2/HSP-2.xml");
        this.tester.assertTextPresent("This file is an XML representation of an issue");
        this.tester.assertTextPresent("Test Bug 2");
    }

    @Test
    public void testRedirectToMovedIssuePrintable() {
        this.tester.gotoPage("/si/jira.issueviews:issue-html/MKY-1/MKY-1.html");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/si/jira.issueviews:issue-html/HSP-2/HSP-2.html");
        this.tester.assertTextPresent("Back to previous view");
        this.tester.assertTextPresent("Test Bug 2");
    }

    @Test
    public void testRedirectToMovedIssueWord() {
        this.tester.gotoPage("/si/jira.issueviews:issue-word/MKY-1/MKY-1.doc");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/si/jira.issueviews:issue-word/HSP-2/HSP-2.doc");
        this.tester.assertTextPresent("application/vnd.ms-word");
        this.tester.assertTextPresent("Test Bug 2");
    }

    @Test
    public void testRedirectToMovedIssueBrowseWithQueryString() {
        this.tester.gotoPage("/browse/MKY-1?jql=haha");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/browse/HSP-2?jql=haha");
    }

    @Test
    public void testRedirectToMovedIssueXMLWithQueryString() {
        this.tester.gotoPage("/si/jira.issueviews:issue-html/MKY-1/MKY-1.html?key1=value1&key2=value2");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/si/jira.issueviews:issue-html/HSP-2/HSP-2.html?key1=value1&key2=value2");
    }
}

