/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import javax.inject.Inject;
import net.sourceforge.jwebunit.ExpectedRow;
import net.sourceforge.jwebunit.ExpectedTable;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueSecurityLevel
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestIssueSecurityLevel.xml");
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_CORE_ACTIVE_DC);
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "bill");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "gandhi");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "joe");
    }

    @Test
    public void testIssueNavigatorVisibility() {
        this.navigation.login("bill");
        this.navigation.issueNavigator().displayAllIssues();
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "PIG-15", "Visible to All Project Leads", "Mahatma Gandhi", "Mark", "", "Open", "Unresolved", "20/Jan/11", "20/Jan/11", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-56", "The Only One - Cowboys", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "16/Nov/18", "16/Nov/18", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-53", "Lovely groups - Cowboys and jira-administrators", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "16/Nov/18", "16/Nov/18", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-51", "Check mates - Cowboys and Losers", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "16/Nov/18", "16/Nov/18", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-49", "ALL THE GROUPS - COWBOYS AND LOSERS", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "16/Nov/18", "16/Nov/18", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-47", "Cowboys and Admins", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-46", "Any User (project role)", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-44", "Friendly Users - Bill included", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-41", "Friendly Group - Cowboy Group", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-40", "Security Level Project Lead", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-39", "Security Level Bill User", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-37", "Issue Assigned to Bill", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-36", "Issue added by Bill.", "Henry Ford", "Wild Bill Hickock", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-35", "Milk the jersey", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-34", "Get along little doggy", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        this.tester.assertTableEquals("issuetable", expectedTable);
        this.tester.assertTextNotPresent("COW-38");
        this.tester.assertTextNotPresent("Issue not assigned to Bill");
        this.tester.assertTextNotPresent("COW-42");
        this.tester.assertTextNotPresent("Friendly Group - No Group");
        this.tester.assertTextNotPresent("COW-43");
        this.tester.assertTextNotPresent("Friendly Group - jira-developers Group");
        this.tester.assertTextNotPresent("COW-45");
        this.tester.assertTextNotPresent("Friendly Users - Bill not included");
        this.tester.assertTextNotPresent("COW-48");
        this.tester.assertTextNotPresent("Reporters and Developers - not reported by Bill");
        this.tester.assertTextNotPresent("COW-50");
        this.tester.assertTextNotPresent("ALL THE GROUPS - No Group");
        this.tester.assertTextNotPresent("COW-52");
        this.tester.assertTextNotPresent("Check mates - Only Losers");
        this.tester.assertTextNotPresent("COW-54");
        this.tester.assertTextNotPresent("Lovely groups - No group");
        this.tester.assertTextNotPresent("COW-55");
        this.tester.assertTextNotPresent("Software users only - sorry, Bill!");
        this.tester.assertTextNotPresent("COW-57");
        this.tester.assertTextNotPresent("The Only One - None");
    }

    @Test
    public void testBrowseIssueVisibility() {
        this.navigation.login("bill");
        this.navigation.issue().viewIssue("COW-34");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-35");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-36");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-37");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-39");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-40");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-41");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-44");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-46");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-47");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-49");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-51");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-53");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-56");
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.issue().viewIssue("COW-38");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-42");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-43");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-45");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-48");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-50");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-52");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-54");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-55");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().viewIssue("COW-57");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testIssueNavigatorVisibility_User_Gandhi() {
        this.navigation.login("gandhi");
        this.navigation.issueNavigator().displayAllIssues();
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "PIG-15", "Visible to All Project Leads", "Mahatma Gandhi", "Mark", "", "Open", "Unresolved", "20/Jan/11", "20/Jan/11", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-55", "Software users only - sorry, Bill!", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "16/Nov/18", "16/Nov/18", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-48", "Reporters and Developers - not reported by Bill", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-46", "Any User (project role)", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-45", "Friendly Users - Bill not included", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-44", "Friendly Users - Bill included", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-43", "Friendly Group - jira-developers Group", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-36", "Issue added by Bill.", "Henry Ford", "Wild Bill Hickock", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-35", "Milk the jersey", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-34", "Get along little doggy", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        this.tester.assertTableEquals("issuetable", expectedTable);
        this.tester.assertTextNotPresent("COW-37");
        this.tester.assertTextNotPresent("Issue assigned to Bill");
        this.tester.assertTextNotPresent("COW-38");
        this.tester.assertTextNotPresent("Issue not assigned to Bill");
        this.tester.assertTextNotPresent("COW-39");
        this.tester.assertTextNotPresent("Security Level Bill User");
        this.tester.assertTextNotPresent("COW-40");
        this.tester.assertTextNotPresent("Security Level Project Leadl");
        this.tester.assertTextNotPresent("COW-41");
        this.tester.assertTextNotPresent("Friendly Group - Cowboy Group");
        this.tester.assertTextNotPresent("COW-42");
        this.tester.assertTextNotPresent("Friendly Group - No Group");
        this.tester.assertTextNotPresent("COW-47");
        this.tester.assertTextNotPresent("Cowboys and Admins");
        this.tester.assertTextNotPresent("COW-49");
        this.tester.assertTextNotPresent("ALL THE GROUPS - COWBOYS AND LOSERS");
        this.tester.assertTextNotPresent("COW-50");
        this.tester.assertTextNotPresent("ALL THE GROUPS - No Group");
        this.tester.assertTextNotPresent("COW-51");
        this.tester.assertTextNotPresent("Check mates - Cowboys and Losers");
        this.tester.assertTextNotPresent("COW-52");
        this.tester.assertTextNotPresent("Check mates - Only Losers");
        this.tester.assertTextNotPresent("COW-53");
        this.tester.assertTextNotPresent("Lovely groups - Cowboys and jira-administrators");
        this.tester.assertTextNotPresent("COW-54");
        this.tester.assertTextNotPresent("Lovely groups - No group");
        this.tester.assertTextNotPresent("COW-56");
        this.tester.assertTextNotPresent("The Only One - Cowboys");
        this.tester.assertTextNotPresent("COW-57");
        this.tester.assertTextNotPresent("The Only One - None");
    }

    @Test
    public void testProjectLeadVisibility() throws Exception {
        this.navigation.login("joe");
        this.navigation.issueNavigator().displayAllIssues();
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "PIG-15", "Visible to All Project Leads", "Mahatma Gandhi", "Mark", "", "Open", "Unresolved", "20/Jan/11", "20/Jan/11", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "LEO-1", "Only Visible to Joe", "Murray", "Mark", "", "Open", "Unresolved", "20/Jan/11", "20/Jan/11", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-46", "Any User (project role)", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-35", "Milk the jersey", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "COW-34", "Get along little doggy", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", "", "Actions"}));
        this.tester.assertTableEquals("issuetable", expectedTable);
    }
}

