/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.DoesNotContainIssueKeyCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.ISSUES})
@Restore(value="TestIssueSecurityLevelOnlyCheckedForBrowseProjectPermission.xml")
@LoginAs(user="admin")
public class TestIssueSecurityLevelOnlyCheckedForBrowseProjectPermission
extends BaseJiraFuncTest {
    private static final String USERNAME = "test";
    private static final String ISSUE_KEY = "TEST-1";
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", USERNAME);
    }

    @Test
    public void testUserCanBeAssignedToIssueEventThoughSheDoesNotBelongToTheGroupsOfTheIssuesSecurityLevel() {
        this.assertUserCanNotSeeIssueSinceSheIsNotAdminNorAssignee(USERNAME, ISSUE_KEY);
        this.assignIssueToUser(ISSUE_KEY, USERNAME);
        this.assertUserCanSeeIssueSinceSheIsTheAssignee(USERNAME, ISSUE_KEY);
    }

    private void assignIssueToUser(String issueKey, String username) {
        this.navigation.login("admin");
        this.navigation.issue().assignIssue(issueKey, "", username);
    }

    private void assertUserCanNotSeeIssueSinceSheIsNotAdminNorAssignee(String username, String issueKey) {
        this.navigation.login(username);
        this.navigation.issueNavigator().createSearch("");
        ArrayList<SearchResultsCondition> condition = new ArrayList<SearchResultsCondition>();
        condition.add(new DoesNotContainIssueKeyCondition(this.textAssertions, issueKey));
        condition.add(new NumberOfIssuesCondition(this.textAssertions, 0));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(condition);
    }

    private void assertUserCanSeeIssueSinceSheIsTheAssignee(String username, String issueKey) {
        this.navigation.login(username);
        this.navigation.issueNavigator().createSearch("");
        ArrayList<SearchResultsCondition> condition = new ArrayList<SearchResultsCondition>();
        condition.add(new ContainsIssueKeysCondition(this.textAssertions, issueKey));
        condition.add(new NumberOfIssuesCondition(this.textAssertions, 1));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(condition);
    }
}

