/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.util.SlowTest;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.ISSUES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfIssue
extends BaseJiraFuncTest {
    public static final String ATL_TOKEN = "atl_token";
    private static final String MY_SUMMARY = "My Summary";
    @Inject
    private Form form;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testXsrfPageCanBeRetried() {
        this.standardCreateIssueSetup();
        this.removeClientSideToken();
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "XSRF Security Token Missing", "Jira could not complete this action due to a missing form token", "The original input has been captured and you can retry the operation");
        this.tester.submit("atl_token_retry_button");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "MKY-1", MY_SUMMARY, "Type:", "Bug");
    }

    @Test
    public void testXsrfPageSessionCanBeRetried() {
        this.standardCreateIssueSetup();
        this.invalidateJSessionID();
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "Session Expired", "You have been logged out because you have not used Jira for approximately 5 hours", "We have captured the submitted values");
    }

    private void invalidateJSessionID() {
        this.tester.getDialog().getWebClient().removeCookie("JSESSIONID");
        this.tester.getDialog().getWebClient().addCookie("JSESSIONID", "invalid");
    }

    private void standardCreateIssueSetup() {
        this.navigation.issue().goToCreateIssueForm("monkey", "Bug");
        this.tester.setFormElement("summary", MY_SUMMARY);
        this.tester.setFormElement("description", "My description");
    }

    private void removeClientSideToken() {
        for (WebForm webForm : this.form.getForms()) {
            if (webForm.hasParameterNamed(ATL_TOKEN)) {
                webForm.getScriptableObject().setParameterValue(ATL_TOKEN, "invalidToken");
            }
            webForm.getScriptableObject().setAction(XsrfCheck.invalidTokenInUrl(webForm.getAction()));
        }
    }

    @Test
    public void testCreateIssue() throws Exception {
        new XsrfTestSuite(new XsrfCheck("CreateIssue", this::standardCreateIssueSetup, new XsrfCheck.FormSubmission("Create"))).run(this.tester, this.navigation, this.form);
    }

    @Test
    public void testWorkFlowActions() throws Exception {
        new XsrfTestSuite(new XsrfCheck("StartProgress", new CreateAndViewIssue(), new XsrfCheck.SuppliedLinkSubmission(() -> this.workflowUtil.getActionUrl("action_id_4"))), new XsrfCheck("StopProgress", new CreateViewIssueAndStartProgress(), new XsrfCheck.SuppliedLinkSubmission(() -> this.workflowUtil.getActionUrl("action_id_301"))), new XsrfCheck("Resolve Issue", new CreateViewIssueAndAssignComment("action_id_5"), new XsrfCheck.FormSubmission("Transition")), new XsrfCheck("Close Issue", new CreateViewIssueAndAssignComment("action_id_2"), new XsrfCheck.FormSubmission("Transition")), new XsrfCheck("Reopen Issue", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.workflowUtil.clickAction("action_id_5");
            this.tester.submit("Transition");
            this.workflowUtil.clickAction("action_id_3");
        }, new XsrfCheck.FormSubmission("Transition"))).run(this.tester, this.navigation, this.form);
    }

    @Test
    public void testIssueLinkingWithInvalidToken() {
        this.linkIssue(this.tester.getTestContext().getBaseUrl(), "invalidtoken");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Jira could not complete this action due to a missing form token.");
    }

    @Test
    public void testIssueLinkingWithInvalidTokenAndReferer() {
        this.linkIssue("http://example.com", "invalidtoken");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Forbidden (403)");
    }

    @Test
    public void testIssueLinkingWithValidToken() {
        this.linkIssue(this.tester.getTestContext().getBaseUrl(), this.page.getXsrfToken());
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Jira could not complete this action due to a missing form token.");
    }

    private void linkIssue(String referer, String xsrfToken) {
        this.administration.issueLinking().enable();
        this.administration.issueLinking().addIssueLink("link", "inward", "outward");
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
        String issueKey2 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", referer);
        StringBuilder url = new StringBuilder().append("/secure/LinkJiraIssue.jspa?atl_token=").append(xsrfToken).append("&id=").append(this.getIssueIdWithIssueKey(issueKey)).append("&linkDesc=").append("inward").append("&currentIssueKey=").append(issueKey).append("&issueKeys=").append(issueKey2);
        this.navigation.gotoPage(url.toString());
    }

    private String getIssueIdWithIssueKey(String issueKey) {
        String issueId;
        this.navigation.issue().gotoIssue(issueKey);
        try {
            String text = this.tester.getDialog().getResponse().getText();
            String paramName = "ViewVoters!default.jspa?id=";
            int issueIdLocation = text.indexOf("ViewVoters!default.jspa?id=") + "ViewVoters!default.jspa?id=".length();
            issueId = text.substring(issueIdLocation, issueIdLocation + 5);
            this.logger.log((Object)("issueId = " + issueId));
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to retrieve issue id" + e.getMessage()));
            return "fail";
        }
        return issueId;
    }

    @Test
    @SlowTest
    public void testIssueOperations() throws Exception {
        this.backdoor.usersAndGroups().addUser("my-user");
        this.backdoor.usersAndGroups().addUserToGroup("my-user", "jira-developers");
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.administration.attachments().enable();
        this.administration.subtasks().enable();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_COMMENTS, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_WORKLOGS, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_WORKLOGS, "jira-users");
        new XsrfTestSuite(new XsrfCheck("Assign - another user", new CreateViewIssueAndAssignComment("Assign", "my-user"), new XsrfCheck.FormSubmission("Assign"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Assign - to me", new CreateAndViewIssue("my-user"), new XsrfCheck.LinkWithTextSubmission("Assign To Me"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Attach file", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Attach file");
        }, new XsrfCheck.FormSubmission("Attach"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Delete Attachment", () -> {
            this.administration.restoreData("TestCloneIssueAttachments.xml");
            this.navigation.gotoPage("/secure/DeleteAttachment!default.jspa?id=10032&deleteAttachmentId=10020");
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Clone", () -> {
            this.administration.restoreBlankInstance();
            this.backdoor.usersAndGroups().addUser("my-user");
            this.backdoor.usersAndGroups().addUserToGroup("my-user", "jira-developers");
            this.administration.attachments().enable();
            this.administration.activateSubTasks();
            this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_COMMENTS, "jira-users");
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_WORKLOGS, "jira-users");
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_WORKLOGS, "jira-users");
            new CreateViewIssueAndAssignComment("Clone").setup();
        }, new XsrfCheck.FormSubmission("Create"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Add Comment", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Comment");
            this.tester.setFormElement("comment", "This is a comment");
        }, new XsrfCheck.FormSubmission("Add"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Delete Comment", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Add comment");
            this.tester.setWorkingForm("comment-add");
            this.tester.setFormElement("comment", "This is a comment");
            this.tester.submit("Add");
            XPathLocator locator1 = new XPathLocator(this.tester, "//div[@id='issue_actions_container']//*[text()='Delete']");
            Node node = locator1.getNode();
            Assertions.notNull("node", node);
            String linkId = ((Attr)node.getAttributes().getNamedItem("id")).getValue();
            this.tester.clickLink(linkId);
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Edit Comment", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Comment");
            this.tester.setFormElement("comment", "This is a comment");
            this.tester.setWorkingForm("comment-add");
            this.tester.submit("Add");
            XPathLocator locator1 = new XPathLocator(this.tester, "//div[@id='issue_actions_container']//*[text()='Edit']");
            Node node = locator1.getNode();
            Assertions.notNull("node", node);
            String linkId = ((Attr)node.getAttributes().getNamedItem("id")).getValue();
            this.tester.clickLink(linkId);
        }, new XsrfCheck.FormSubmission("Save"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Create sub-task", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLink("create-subtask");
            this.tester.setFormElement("summary", "This is my subtask");
        }, new XsrfCheck.FormSubmission("Create"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Delete", new CreateViewIssueAndAssignComment("Delete"), new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Edit", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLink("edit-issue");
            this.tester.setFormElement("description", "My edit description");
        }, new XsrfCheck.FormSubmission("Update"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Move", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Move");
            this.navigation.issue().selectProject("homosapien");
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
        }, new XsrfCheck.FormSubmission("Move"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Convert to sub-task", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            String issueKey2 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Convert");
            this.tester.setFormElement("parentIssueKey", issueKey2);
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
        }, new XsrfCheck.FormSubmission("Finish"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Move this subtask", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            String issueKey2 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
            String issueKey3 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug3");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Convert");
            this.tester.setFormElement("parentIssueKey", issueKey2);
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
            this.tester.submit("Finish");
            this.tester.clickLinkWithText("Move");
            this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
            this.tester.submit("Next >>");
            this.tester.setFormElement("parentIssue", issueKey3);
        }, new XsrfCheck.FormSubmission("Change Parent"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Convert to Issue", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            String issueKey2 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Convert");
            this.tester.setFormElement("parentIssueKey", issueKey2);
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
            this.tester.submit("Finish");
            this.tester.clickLinkWithText("Convert");
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
        }, new XsrfCheck.FormSubmission("Finish"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Add subtask", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            String issueKey2 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Convert");
            this.tester.setFormElement("parentIssueKey", issueKey2);
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
            this.tester.submit("Finish");
            this.navigation.issue().viewIssue(issueKey2);
            this.tester.clickLink("stqc_show");
            this.tester.setFormElement("summary", "my subtask");
        }, new XsrfCheck.FormSubmission("Create"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Log Work", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Log Work");
            this.tester.setFormElement("timeLogged", "1h");
        }, new XsrfCheck.FormSubmission("Log"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Delete Work Log", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Log Work");
            this.tester.setFormElement("timeLogged", "1h");
            this.tester.submit("Log");
            this.tester.clickLink("all-tabpanel-link");
            this.tester.clickLinkWithText("Work Log");
            XPathLocator locator1 = new XPathLocator(this.tester, "//div[@id='issue_actions_container']//*[text()='Delete']");
            Node node = locator1.getNode();
            Assertions.notNull("node", node);
            String linkId = ((Attr)node.getParentNode().getAttributes().getNamedItem("id")).getValue();
            this.tester.clickLink(linkId);
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
        new XsrfTestSuite(new XsrfCheck("Edit Work Log", () -> {
            String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLinkWithText("Log Work");
            this.tester.setFormElement("timeLogged", "1h");
            this.tester.submit("Log");
            this.tester.clickLink("all-tabpanel-link");
            this.tester.clickLinkWithText("Work Log");
            XPathLocator locator1 = new XPathLocator(this.tester, "//div[@id='issue_actions_container']//*[text()='Edit']");
            Node node = locator1.getNode();
            Assertions.notNull("node", node);
            String linkId = ((Attr)node.getParentNode().getAttributes().getNamedItem("id")).getValue();
            this.tester.clickLink(linkId);
        }, new XsrfCheck.FormSubmission("Log"))).run(this.tester, this.navigation, this.form);
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
    }

    @Test
    public void testVotingOrWatching() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.navigation.login("fred");
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
        this.navigation.login("admin");
        new XsrfTestSuite(new XsrfCheck("Vote for an issue", () -> this.navigation.issue().viewIssue(issueKey), new XsrfCheck.LinkWithIdSubmission("vote-toggle")), new XsrfCheck("Watch an issue", () -> this.navigation.issue().viewIssue(issueKey), new XsrfCheck.LinkWithIdSubmission("watching-toggle")), new XsrfCheck("Unvote an issue", () -> {
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLink("vote-toggle");
        }, new XsrfCheck.LinkWithIdSubmission("vote-toggle")), new XsrfCheck("Unwatch an issue", () -> {
            this.navigation.issue().viewIssue(issueKey);
            this.tester.clickLink("watching-toggle");
        }, new XsrfCheck.LinkWithIdSubmission("watching-toggle")), new XsrfCheck("View Voters - Un Vote", () -> this.tester.gotoPage("secure/ViewVoters!default.jspa?id=10000"), new XsrfCheck.LinkWithIdSubmission("unvote")), new XsrfCheck("View Voters - Vote", () -> this.tester.gotoPage("secure/ViewVoters!default.jspa?id=10000"), new XsrfCheck.LinkWithIdSubmission("vote")), new XsrfCheck("Manager Watches - Un Watch", () -> this.tester.gotoPage("secure/ManageWatchers!default.jspa?id=10000"), new XsrfCheck.LinkWithIdSubmission("unwatch")), new XsrfCheck("Manager Watches - Watch", () -> this.tester.gotoPage("secure/ManageWatchers!default.jspa?id=10000"), new XsrfCheck.LinkWithIdSubmission("watch")), new XsrfCheck("Manager Watches - Add Watcher", () -> {
            this.tester.gotoPage("secure/ManageWatchers!default.jspa?id=10000");
            this.tester.setFormElement("userNames", "fred");
        }, new XsrfCheck.FormSubmission("add"))).run(this.tester, this.navigation, this.form);
    }

    class CreateViewIssueAndAssignComment
    implements XsrfCheck.Setup {
        private final String linkText;
        private final String assignee;

        public CreateViewIssueAndAssignComment(String linkText, String assignee) {
            this.linkText = linkText;
            this.assignee = assignee;
        }

        public CreateViewIssueAndAssignComment(String linkText) {
            this.linkText = linkText;
            this.assignee = null;
        }

        @Override
        public void setup() {
            String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
            if (TestXsrfIssue.this.workflowUtil.isActionId(this.linkText)) {
                TestXsrfIssue.this.workflowUtil.clickAction(this.linkText);
            } else {
                TestXsrfIssue.this.tester.clickLinkWithText(this.linkText);
            }
            if (this.assignee != null) {
                TestXsrfIssue.this.tester.selectOption("assignee", this.assignee);
            }
        }
    }

    class CreateViewIssueAndStartProgress
    implements XsrfCheck.Setup {
        CreateViewIssueAndStartProgress() {
        }

        @Override
        public void setup() {
            String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
            TestXsrfIssue.this.workflowUtil.clickAction("action_id_4");
        }
    }

    class CreateAndViewIssue
    implements XsrfCheck.Setup {
        String assignee;

        public CreateAndViewIssue() {
        }

        public CreateAndViewIssue(String assignee) {
            this.assignee = assignee;
        }

        @Override
        public void setup() {
            String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            if (this.assignee != null) {
                TestXsrfIssue.this.navigation.issue().assignIssue(issueKey, "", this.assignee);
            }
            TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
        }
    }
}

