/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.ISSUES})
@LoginAs(user="admin")
public class TestXsrfSpecificLinks
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestXsrfSpecificLinks.xml");
    }

    @Test
    public void testLinksThatShouldNOTHaveAtlTokens() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertAnchorsDoNotHaveToken("//dl[contains(@class, 'links-list')]//dd//span//a/@href");
        this.assertAnchorsDoNotHaveToken("//*[@id='issue-tabs']//a/@href");
        this.navigation.issueNavigator().createSearch("project=HSP");
        this.navigation.issueNavigator().createSearch("project=HSP and summary ~ fred");
        this.navigation.issueNavigator().createSearch("project=HSP and summary ~ bill");
    }

    private void assertAnchorsDoNotHaveToken(String xPath) {
        String allHrefs = new XPathLocator(this.tester, xPath).getText();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)allHrefs));
        this.textAssertions.assertTextNotPresent(allHrefs, "atl_token");
    }
}

