/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.license.TestCreateUserHelper;
import com.google.common.collect.Sets;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@LoginAs(user="admin")
public class TestCreateUserMultiApplicationInstance
extends TestCreateUserHelper {
    private static final String PLATFORM_GROUP = "platform-users";
    private static final String TEST_GROUP1 = "test-users";
    private static final String TEST_GROUP2 = "test-users2";
    private static final String ADMIN_GROUP = "jira-administrators";

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance(LicenseKeys.MULTI_ROLE_DC);
        this.backdoor.applicationRoles().putRole("jira-func-test", new String[0]);
        this.backdoor.applicationRoles().putRole("jira-core", new String[0]);
        this.backdoor.applicationRoles().putRole("jira-servicedesk", new String[0]);
        this.backdoor.applicationRoles().putRole("jira-software", new String[0]);
        this.backdoor.applicationRoles().putRole("jira-reference", new String[0]);
    }

    @Test
    public void testShouldCreateUserAndAddToGroupsOfMultipleApplications() {
        this.backdoor.usersAndGroups().addGroup(PLATFORM_GROUP);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP, ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP}));
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP1);
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP2);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-func-test", Sets.newHashSet((Object[])new String[]{TEST_GROUP1, TEST_GROUP2}), Sets.newHashSet((Object[])new String[]{TEST_GROUP1, TEST_GROUP2}));
        this.populateCreateUserForm("user");
        this.tester.checkCheckbox("selectedApplications", "jira-core");
        this.tester.checkCheckbox("selectedApplications", "jira-func-test");
        this.tester.submit("Create");
        this.assertUserInGroups("user", PLATFORM_GROUP, TEST_GROUP1, TEST_GROUP2);
    }

    @Test
    public void testShouldCreateUserAndOnlyAddToDefaultGroupOfSelectedApplication() {
        this.backdoor.usersAndGroups().addGroup(PLATFORM_GROUP);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP, ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP}));
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP1);
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", TEST_GROUP1);
        this.populateCreateUserForm("user");
        this.assertHasCheckbox("jira-func-test");
        this.tester.checkCheckbox("selectedApplications", "jira-core");
        this.tester.submit("Create");
        this.assertUserInGroups("user", PLATFORM_GROUP);
    }

    @Test
    public void testShouldCreateUserWhenAdminHasNotSelectedAnyApplications() {
        this.backdoor.usersAndGroups().addGroup(PLATFORM_GROUP);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP}), Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP}));
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP1);
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", TEST_GROUP1);
        this.populateCreateUserForm("user");
        this.assertHasCheckbox("jira-func-test");
        this.assertHasCheckbox("jira-core");
        this.tester.uncheckCheckbox("selectedApplications");
        this.tester.submit("Create");
        this.assertUserNotInAnyGroups("user");
    }

    @Test
    public void testShouldWarnUserWhenOneOfAppsHasReachedLicenseLimitAndAllowCreationUsingOtherApp() {
        this.backdoor.usersAndGroups().addGroup(PLATFORM_GROUP);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP, ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP}));
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP1);
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", TEST_GROUP1);
        int LIC_USER_LIMIT = 3;
        for (int i = 1; i < 3; ++i) {
            this.populateCreateUserForm("user" + i);
            this.tester.checkCheckbox("selectedApplications", "jira-core");
            this.tester.submit("Create");
            this.assertUserInGroups("user" + i, PLATFORM_GROUP);
        }
        this.populateCreateUserForm("noGroupUser");
        this.assertNoCheckboxButWarningButton("jira-core");
        this.tester.checkCheckbox("selectedApplications", "jira-func-test");
        this.tester.submit("Create");
        this.assertUserInGroups("noGroupUser", TEST_GROUP1);
    }

    @Test
    public void testShouldWarnUserWhenApplicationHasNoDefaultGroup() {
        this.populateCreateUserForm("user");
        this.assertNoCheckboxButWarningButton("jira-func-test");
        this.tester.submit("Create");
        this.assertUserNotInAnyGroups("user");
    }

    @Test
    public void testRoleUserLimitsWhenAllRolesUnderLimit() {
        this.setupRoleWithUsers("jira-func-test", 4, TEST_GROUP1);
        this.setupRoleWithUsers("jira-software", 4, "software-users");
        this.navigation.gotoAdmin();
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA");
    }

    @Test
    public void testRoleUserLimitsWhenOneRoleOverLimit() {
        this.setupRoleWithUsers("jira-func-test", 4, TEST_GROUP1);
        this.setupRoleWithUsers("jira-software", 5, "software-users");
        this.navigation.gotoAdmin();
        this.tester.assertTextPresent("license's user limit is exceeded.");
    }

    @Test
    public void testRoleUserLimitsWhenAllRolesOverLimit() {
        this.setupRoleWithUsers("jira-func-test", 5, TEST_GROUP1);
        this.setupRoleWithUsers("jira-software", 5, "software-users");
        this.navigation.gotoAdmin();
        this.tester.assertTextPresent("Users may not be able to create issues");
    }

    void setupRoleWithUsers(String roleName, int numUsers, String groupName) {
        this.backdoor.usersAndGroups().addGroup(groupName);
        this.backdoor.applicationRoles().putRoleAndSetDefault(roleName, groupName);
        String userNamePrefix = "user-of-" + groupName;
        this.backdoor.usersAndGroups().addUsersWithGroup(userNamePrefix, userNamePrefix, numUsers, groupName);
    }
}

