/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@LoginAs(user="admin")
public class TestLicenseFooters
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testEnterpriseCommunityLicense() {
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.COMMUNITY_DC);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Powered by a free Atlassian", "community license for Atlassian.");
        this.tester.assertTextNotPresent("site is for non-production use only.");
        this.tester.assertTextNotPresent("open source license for Atlassian.");
        this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
    }

    @Test
    public void testEnterpriseCommunityLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstanceWithLicense(LicenseKeys.COMMUNITY_DC);
            this.navigation.logout();
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Powered by a free Atlassian", "community license for Atlassian.");
            this.tester.assertTextNotPresent("site is for non-production use only.");
            this.tester.assertTextNotPresent("open source license for Atlassian.");
            this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testEnterpriseDeveloperLicense() {
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.DEVELOPER_DC);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "This", "site is for non-production use only.");
        this.tester.assertTextNotPresent("Powered by a free Atlassian");
        this.tester.assertTextNotPresent("community license for Atlassian.");
        this.tester.assertTextNotPresent("open source license for Atlassian.");
        this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
    }

    @Test
    public void testEnterpriseDeveloperLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstanceWithLicense(LicenseKeys.DEVELOPER_DC);
            this.navigation.logout();
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "This", "site is for non-production use only.");
            this.tester.assertTextNotPresent("Powered by a free Atlassian");
            this.tester.assertTextNotPresent("community license for Atlassian.");
            this.tester.assertTextNotPresent("open source license for Atlassian.");
            this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testEnterprisePersonalLicense() {
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.PERSONAL_DC);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"A", "free bug tracker", "for up to three users? Try", "Jira Personal", "Edition."});
        this.tester.assertTextNotPresent("Powered by a free Atlassian");
        this.tester.assertTextNotPresent("community license for Atlassian.");
        this.tester.assertTextNotPresent("open source license for Atlassian.");
        this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
        this.tester.assertTextNotPresent("site is for non-production use only.");
    }

    @Test
    public void testEnterprisePersonalLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstanceWithLicense(LicenseKeys.PERSONAL_DC);
            this.navigation.logout();
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"A", "free bug tracker", "for up to three users? Try", "Jira Personal", "Edition."});
            this.tester.assertTextNotPresent("Powered by a free Atlassian");
            this.tester.assertTextNotPresent("community license for Atlassian.");
            this.tester.assertTextNotPresent("open source license for Atlassian.");
            this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
            this.tester.assertTextNotPresent("site is for non-production use only.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testEnterpriseOpenSourceLicense() {
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.OPEN_SOURCE_DC);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Powered by a free Atlassian", "open source license for Atlassian.");
        this.tester.assertTextNotPresent("community license for Atlassian.");
        this.tester.assertTextNotPresent("site is for non-production use only.");
        this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
    }

    @Test
    public void testEnterpriseOpenSourceLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstanceWithLicense(LicenseKeys.OPEN_SOURCE_DC);
            this.navigation.logout();
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Powered by a free Atlassian", "open source license for Atlassian.");
            this.tester.assertTextNotPresent("community license for Atlassian.");
            this.tester.assertTextNotPresent("site is for non-production use only.");
            this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testEnterpriseDemonstrationLicense() {
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.DEMO_DC);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "This Jira site is for demonstration purposes only.", "bug tracking software for your team.");
        this.tester.assertTextNotPresent("Powered by a free Atlassian");
        this.tester.assertTextNotPresent("community license for Atlassian.");
        this.tester.assertTextNotPresent("site is for non-production use only.");
        this.tester.assertTextNotPresent("open source license for Atlassian.");
    }

    @Test
    public void testEnterpriseDemonstrationLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstanceWithLicense(LicenseKeys.DEMO_DC);
            this.navigation.logout();
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "This Jira site is for demonstration purposes only.", "bug tracking software for your team.");
            this.tester.assertTextNotPresent("Powered by a free Atlassian");
            this.tester.assertTextNotPresent("community license for Atlassian.");
            this.tester.assertTextNotPresent("site is for non-production use only.");
            this.tester.assertTextNotPresent("open source license for Atlassian.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testEnterpriseLicense() {
        this.administration.restoreBlankInstance();
        this.tester.assertTextNotPresent("Powered by a free Atlassian");
        this.tester.assertTextNotPresent("community license for Atlassian.");
        this.tester.assertTextNotPresent("site is for non-production use only.");
        this.tester.assertTextNotPresent("Powered by a free Atlassian");
        this.tester.assertTextNotPresent("open source license for Atlassian.");
        this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
    }

    @Test
    public void testEnterpriseLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstance();
            this.navigation.logout();
            this.tester.assertTextNotPresent("Powered by a free Atlassian");
            this.tester.assertTextNotPresent("community license for Atlassian.");
            this.tester.assertTextNotPresent("site is for non-production use only.");
            this.tester.assertTextNotPresent("open source license for Atlassian.");
            this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testEnterpriseEvaluationLicense() {
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.EVAL_EXPIRED_DC);
        this.navigation.gotoPage("secure/BrowseProjects.jspa");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Powered by a free Atlassian", "Jira evaluation license", "Please consider", "purchasing it", "today"});
        this.tester.assertTextNotPresent("community license for Atlassian.");
        this.tester.assertTextNotPresent("site is for non-production use only.");
        this.tester.assertTextNotPresent("open source license for Atlassian.");
        this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
        this.tester.assertTextNotPresent("for up to three users? Try");
    }

    @Test
    public void testEnterpriseEvaluationLicenseLoggedOut() {
        try {
            this.administration.restoreBlankInstanceWithLicense(LicenseKeys.EVAL_EXPIRED_DC);
            this.navigation.logout();
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Powered by a free Atlassian", "Jira evaluation license", "Please consider", "purchasing it", "today"});
            this.tester.assertTextNotPresent("community license for Atlassian.");
            this.tester.assertTextNotPresent("site is for non-production use only.");
            this.tester.assertTextNotPresent("open source license for Atlassian.");
            this.tester.assertTextNotPresent("This Jira site is for demonstration purposes only.");
            this.tester.assertTextNotPresent("for up to three users? Try");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }
}

