/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@LoginAs(user="admin")
public class TestLicenseMessages
extends BaseJiraFuncTest {
    private static final String URL_WWW_ATLASSIAN_COM_EXPIRED_EVAL = "http://www.atlassian.com/software/jira/expiredevaluation.jsp";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    private static LicenseInfo createSupportedLicense(License forLicense) {
        return new LicenseInfo(forLicense, new String[]{"(Support and updates available until "}, new String[]{"Jira support and updates for this license ended on ", "Jira support and updates created after ", "are not valid for this license."}, new LicenseInfoUrl[0]);
    }

    private static LicenseInfo createUnsupportedLicense(License forLicense) {
        return new LicenseInfo(forLicense, new String[]{"(Updates available until "}, new String[0], new LicenseInfoUrl[0]);
    }

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testSwitchableLicenses() throws Exception {
        ImmutableList switchableLicenses = ImmutableList.of((Object)new LicenseInfo(LicenseKeys.EVAL_EXPIRED, new String[]{"(Your evaluation has expired.)", "Your Jira evaluation period expired on ", "You are not able to create new issues in Jira.", "To reactivate Jira, please "}, new String[0], new LicenseInfoUrl[]{new LicenseInfoUrl("purchase Jira", URL_WWW_ATLASSIAN_COM_EXPIRED_EVAL)}), (Object)new LicenseInfo(LicenseKeys.COMMERCIAL, new String[]{"(Support and updates available until "}, new String[0], new LicenseInfoUrl[0]), (Object)TestLicenseMessages.createSupportedLicense(LicenseKeys.COMMUNITY), (Object)TestLicenseMessages.createSupportedLicense(LicenseKeys.DEVELOPER), (Object)TestLicenseMessages.createUnsupportedLicense(LicenseKeys.PERSONAL), (Object)TestLicenseMessages.createSupportedLicense(LicenseKeys.OPEN_SOURCE), (Object)TestLicenseMessages.createUnsupportedLicense(LicenseKeys.DEMO));
        for (LicenseInfo licenseInfo : switchableLicenses) {
            this.logger.log((Object)("Testing license for " + licenseInfo.description));
            this.administration.switchToLicense(licenseInfo.license, licenseInfo.description);
            if (!licenseInfo.license.equals(LicenseKeys.EVAL_EXPIRED.getLicenseString())) continue;
            this.tester.gotoPage("secure/CreateIssue!default.jspa");
            this.assertCantCreateIssues();
            this.tester.gotoPage("secure/CreateIssue.jspa?pid=10000&issuetype=1");
            this.assertCantCreateIssues();
        }
    }

    private void assertCantCreateIssues() {
        CssLocator locator = new CssLocator(this.tester, ".aui-message.aui-message-error");
        this.textAssertions.assertTextPresent(locator, "You will not be able to create new issues until you renew your license, please contact your Jira administrators.");
    }

    private static class LicenseInfoUrl {
        String text;
        String url;

        private LicenseInfoUrl(String text, String url) {
            this.text = text;
            this.url = url;
        }
    }

    private static class LicenseInfo {
        final String license;
        final String description;
        final String[] messages;
        final String[] notMessages;
        final LicenseInfoUrl[] urls;

        private LicenseInfo(License forLicense, String[] messages, String[] notMessages, LicenseInfoUrl[] urls) {
            this.license = forLicense.getLicenseString();
            this.description = forLicense.getDescription();
            this.messages = messages;
            this.notMessages = notMessages;
            this.urls = urls;
        }
    }
}

