/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.SalLicenseControl;
import com.atlassian.jira.functest.framework.backdoor.SingleProductLicenseDetailsViewTO;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.test.util.lic.sd.ServiceDeskLicenses;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@LoginAs(user="admin")
public class TestServiceDeskLicenses
extends BaseJiraFuncTest {
    private SalLicenseControl license;

    @Before
    public void setUpTest() {
        this.license = new SalLicenseControl(this.getEnvironmentData());
        this.backdoor.restoreBlankInstance(LicenseKeys.COMMERCIAL);
    }

    @After
    public void tearDownTest() {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL);
    }

    @Test
    public void testServiceDeskLicenses() {
        List<License> licenses = Arrays.asList(ServiceDeskLicenses.LICENSE_SERVICE_DESK_TBP, ServiceDeskLicenses.LICENSE_SERVICE_DESK_TBP_EVAL, ServiceDeskLicenses.LICENSE_SERVICE_DESK_TBP_UNLIMITED, ServiceDeskLicenses.LICENSE_SERVICE_DESK_ABP, ServiceDeskLicenses.LICENSE_SERVICE_DESK_ABP_EVAL, ServiceDeskLicenses.LICENSE_SERVICE_DESK_RBP, ServiceDeskLicenses.LICENSE_SERVICE_DESK_RBP_EVAL);
        for (License lic : licenses) {
            SalLicenseControl.ValidationResultTO to = this.license.validateLicenseString("jira-servicedesk", lic, Locale.ENGLISH);
            if (!to.isValid()) {
                StringWriter out = new StringWriter();
                PrintWriter writer = new PrintWriter(out);
                writer.printf("License %s is invalid.%n", StringUtils.abbreviate((String)lic.getLicenseString(), (int)20));
                writer.println("Errors:");
                for (String s : to.getErrorMessages()) {
                    writer.print("\t");
                    writer.println(s);
                }
                writer.println("Warnings:");
                for (String s : to.getWarningMessages()) {
                    writer.print("\t");
                    writer.println(s);
                }
                writer.close();
                Assert.fail((String)out.toString());
            }
            Assert.assertTrue((boolean)this.license.addProductLicense("jira-servicedesk", lic));
            TestServiceDeskLicenses.assertLicenseEqual(lic, this.license.getProductLicenseDetails("jira-servicedesk"));
        }
    }

    @Test
    public void testServiceDeskExpiredEvalLicenseIsRejected() {
        this.assertInvalidLicense(ServiceDeskLicenses.LICENSE_SERVICE_DESK_TBP_EVAL_EXPIRED);
    }

    @Test
    public void testMixingCommercialWithAcademicIsValid() {
        this.assertValidLicense(ServiceDeskLicenses.LICENSE_SERVICE_DESK_ABP_ACADEMIC);
    }

    @Test
    public void testMixingCommercialWithCommunityIsRejected() {
        this.assertInvalidLicense(ServiceDeskLicenses.LICENSE_SERVICE_DESK_ABP_COMMUNITY);
    }

    private void assertInvalidLicense(License licenseKey) {
        SalLicenseControl.ValidationResultTO to = this.license.validateLicenseString("jira-servicedesk", licenseKey, Locale.ENGLISH);
        Assert.assertFalse((boolean)to.isValid());
    }

    private void assertValidLicense(License licenseKey) {
        SalLicenseControl.ValidationResultTO to = this.license.validateLicenseString("jira-servicedesk", licenseKey, Locale.ENGLISH);
        Assert.assertTrue((boolean)to.isValid());
    }

    private static void assertLicenseEqual(License expectedLicense, SingleProductLicenseDetailsViewTO actual) {
        Assert.assertEquals((Object)expectedLicense.getDescription(), (Object)actual.description);
        Assert.assertEquals((Object)expectedLicense.getOrganisation(), (Object)actual.organisationName);
        Assert.assertEquals((Object)expectedLicense.getSen(), (Object)actual.supportEntitlementNumber);
        Assert.assertEquals((Object)expectedLicense.isEvaluation(), (Object)actual.isEvaluationLicense);
        Assert.assertEquals((Object)expectedLicense.getSubscriptionExpiryDate().isEmpty(), (Object)actual.isPerpetualLicense);
        License.Role role = (License.Role)Iterables.getOnlyElement(expectedLicense.getRoles().values());
        Assert.assertEquals((Object)role.getProduct(), (Object)actual.productKey);
        Assert.assertEquals((Object)role.isUnlimitedUsers(), (Object)actual.isUnlimitedNumberOfUsers);
        Assert.assertEquals((long)role.getNumberOfUsers(), (long)actual.numberOfUsers);
    }
}

