/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.PluginsControlExt;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public abstract class BaseJmxMetricsTest
extends BaseJiraFuncTest {
    protected static final String NOISY_NEIGHBOUR_JIRA_PLUGIN_KEY = "com.atlassian.diagnostics.noisy-neighbour-jira-plugin";
    protected static final String NOISY_NEIGHBOUR_PLUGIN_KEY = "com.atlassian.diagnostics.noisy-neighbour-plugin";
    private static final String NOISY_NEIGHBOR_PLUGIN_VERSION = "1.2.4";
    private static final String NOISY_NEIGHBOR_PLUGIN_URL = String.format("https://packages.atlassian.com/maven-public/com/atlassian/diagnostics/noisy-neighbour-jira-plugin/%s/noisy-neighbour-jira-plugin-%s.obr", "1.2.4", "1.2.4");
    private final Client client = this.createClient();

    protected void startNoisyNeighbourOperation(String metricName) {
        this.client.target(this.getBaseUrl() + "/rest/noisyneighbour/latest/admin/block").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)metricName), Response.class);
    }

    protected List<String> getJmxBeans() {
        return (List)((Response)this.client.target(this.getBaseUrl() + "/rest/noisyneighbour/latest/jmx").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class)).readEntity((GenericType)new GenericType<List<String>>(){});
    }

    protected void tryAssertUntil(Runnable assertions) {
        Awaitility.await().atMost(Duration.TEN_SECONDS).pollInterval(Duration.FIVE_HUNDRED_MILLISECONDS).until(assertions);
    }

    protected void waitUntil(Callable<Boolean> condition, Duration timeout) {
        Awaitility.await().timeout(timeout).pollInterval(Duration.TWO_HUNDRED_MILLISECONDS).until(condition);
    }

    protected Map<?, ?> awaitFirstAnalyticsEvent(Matcher<Map<String, String>> eventMatcher) {
        return (Map)Awaitility.await().timeout(Duration.TWO_MINUTES).until(() -> {
            List<Map<?, ?>> events = this.backdoor.analyticsEventsControl().matchEvents("profiling.metric");
            return events.stream().map(e -> (Map)e.get("properties")).filter(arg_0 -> ((Matcher)eventMatcher).matches(arg_0)).findFirst().orElse(null);
        }, Matchers.notNullValue());
    }

    private void enableJmxAndAppMonitoring() {
        this.getBackdoor().profiling().enableJmx();
        this.getBackdoor().profiling().enableAppMonitoring();
    }

    private void disableJmxAndAppMonitoring() {
        this.getBackdoor().profiling().disableJmx();
        this.getBackdoor().profiling().disableAppMonitoring();
    }

    private void enableNoisyNeighbourPlugin() throws MalformedURLException {
        if (!this.isNoisyNeighbourInstalled()) {
            this.getBackdoor().plugins().uploadPlugin(new URL(NOISY_NEIGHBOR_PLUGIN_URL));
        }
        this.getBackdoor().plugins().enablePlugin(NOISY_NEIGHBOUR_PLUGIN_KEY);
        this.waitForPluginToBeEnabled(NOISY_NEIGHBOUR_PLUGIN_KEY);
        this.getBackdoor().plugins().enablePlugin(NOISY_NEIGHBOUR_JIRA_PLUGIN_KEY);
        this.waitForPluginToBeEnabled(NOISY_NEIGHBOUR_JIRA_PLUGIN_KEY);
    }

    private void disableNoisyNeighbourPlugin() {
        this.getBackdoor().plugins().disablePlugin(NOISY_NEIGHBOUR_JIRA_PLUGIN_KEY);
        this.getBackdoor().plugins().disablePlugin(NOISY_NEIGHBOUR_PLUGIN_KEY);
    }

    private boolean isNoisyNeighbourInstalled() {
        return this.getBackdoor().plugins().listPlugins().stream().anyMatch(pluginBean -> pluginBean.getKey().equals(NOISY_NEIGHBOUR_JIRA_PLUGIN_KEY) && pluginBean.getVersion().equals(NOISY_NEIGHBOR_PLUGIN_VERSION));
    }

    private Client createClient() {
        ClientConfig config = new ClientConfig().register(JacksonJsonProvider.class).register((Object)HttpAuthenticationFeature.basicBuilder().credentials("admin", "admin").build()).register(httpClientBuilder -> {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(20);
            connectionManager.setMaxTotal(100);
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        });
        return ClientBuilder.newClient((Configuration)config);
    }

    private String getBaseUrl() {
        return this.environmentData.getBaseUrl().toExternalForm();
    }

    private void waitForPluginToBeEnabled(String pluginKey) {
        Awaitility.await((String)("waiting for plugin to be enabled: " + pluginKey)).timeout(Duration.ONE_MINUTE).pollInterval(Duration.FIVE_HUNDRED_MILLISECONDS).until(() -> this.isPluginEnabled(pluginKey));
    }

    private boolean isPluginEnabled(String pluginKey) {
        PluginsControlExt plugins = this.getBackdoor().plugins();
        Optional<PluginsControlExt.PluginBean> optPlugin = plugins.getPlugin(pluginKey);
        return optPlugin.isPresent() && optPlugin.get().getEnabled() != false;
    }

    protected class JmxNoisyNeighbourRule
    extends ExternalResource {
        private final List<String> enabledOptionalFields = new ArrayList<String>();

        protected JmxNoisyNeighbourRule() {
        }

        protected void before() throws Throwable {
            BaseJmxMetricsTest.this.enableJmxAndAppMonitoring();
            BaseJmxMetricsTest.this.enableNoisyNeighbourPlugin();
        }

        protected void after() {
            this.cleanUpOptionalFields();
            BaseJmxMetricsTest.this.disableNoisyNeighbourPlugin();
            BaseJmxMetricsTest.this.disableJmxAndAppMonitoring();
        }

        public void enableOptionalField(String metricName, String tagName) {
            String metricPropertyKey = "atlassian.metrics.optional.tags." + metricName;
            BaseJmxMetricsTest.this.backdoor.systemProperties().setProperty(metricPropertyKey, tagName);
            this.reloadProfilingConfig();
            this.enabledOptionalFields.add(metricPropertyKey);
        }

        private void cleanUpOptionalFields() {
            this.enabledOptionalFields.forEach(field -> BaseJmxMetricsTest.this.backdoor.systemProperties().unsetProperty(field));
            this.enabledOptionalFields.clear();
            this.reloadProfilingConfig();
        }

        private void reloadProfilingConfig() {
            BaseJmxMetricsTest.this.client.target(BaseJmxMetricsTest.this.getBaseUrl() + "/rest/noisyneighbour/latest/reloadProfiling").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null, Response.class);
        }
    }
}

