/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestAtlassianCoreJmxMetrics
extends BaseJmxMetricsTest {
    @Rule
    public BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);
    private static final String EXPECTED_JMX_LONG_RUNNING_TASK_METRIC_PREFIX = "com.atlassian.jira:name=longRunningTask";
    private static final String EXPECTED_JMX_LONG_RUNNING_TASK_METRIC_SUFFIX = "tag.taskClass=com.atlassian.diagnostics.noisyneighbour.operations.task.LongRunningTaskOperation.MyLongRunningTask,tag.taskName=myLongRunningTask,type=metrics";
    private static final String LONG_RUNNING_TASK_OPERATION = "LONG_RUNNING_TASK_OPERATION";
    private static final String TASK_QUEUE_OPERATION = "TASK_QUEUE_OPERATION";

    @Test
    public void coreLongRunningTaskOperation_emitsMetrics() {
        this.startNoisyNeighbourOperation(LONG_RUNNING_TASK_OPERATION);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"com.atlassian.jira:name=longRunningTask,tag.taskClass=com.atlassian.diagnostics.noisyneighbour.operations.task.LongRunningTaskOperation.MyLongRunningTask,tag.taskName=myLongRunningTask,type=metrics", "com.atlassian.jira:name=longRunningTask,tag.statistic=active,tag.subCategory=current,tag.taskClass=com.atlassian.diagnostics.noisyneighbour.operations.task.LongRunningTaskOperation.MyLongRunningTask,tag.taskName=myLongRunningTask,type=metrics", "com.atlassian.jira:name=longRunningTask,tag.statistic=duration,tag.subCategory=current,tag.taskClass=com.atlassian.diagnostics.noisyneighbour.operations.task.LongRunningTaskOperation.MyLongRunningTask,tag.taskName=myLongRunningTask,type=metrics", "com.atlassian.jira:name=longRunningTask,tag.statistic=max,tag.subCategory=current,tag.taskClass=com.atlassian.diagnostics.noisyneighbour.operations.task.LongRunningTaskOperation.MyLongRunningTask,tag.taskName=myLongRunningTask,type=metrics"}));
        });
    }

    @Test
    public void coreTaskOperation_emitsMetrics() {
        this.startNoisyNeighbourOperation(TASK_QUEUE_OPERATION);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"com.atlassian.jira:name=task,tag.queueName=DefaultTaskQueue,type=metrics", "com.atlassian.jira:name=task,tag.queueName=ErrorQueuedTaskQueue,type=metrics"}));
        });
    }
}

