/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestAtlassianPluginJmxMetrics
extends BaseJmxMetricsTest {
    @Rule
    public final BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);
    private static final String EXPECTED_JMX_PLUGIN_DISABLED_METRIC = "com.atlassian.jira:category00=plugin,category01=disabled,name=counter,type=metrics";
    private static final String EXPECTED_JMX_PLUGIN_ENABLED_METRIC = "com.atlassian.jira:category00=plugin,category01=enabled,name=counter,type=metrics";

    @Test
    public void enableAndDisablePluginShouldEmitsMetrics() {
        this.setNoisyNeighbourPluginEnabled(false);
        this.setNoisyNeighbourPluginEnabled(true);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItem((Object)EXPECTED_JMX_PLUGIN_DISABLED_METRIC));
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItem((Object)EXPECTED_JMX_PLUGIN_ENABLED_METRIC));
        });
    }

    private void setNoisyNeighbourPluginEnabled(boolean enabled) {
        if (enabled) {
            this.getBackdoor().plugins().enablePlugin("com.atlassian.diagnostics.noisy-neighbour-jira-plugin");
        } else {
            this.getBackdoor().plugins().disablePlugin("com.atlassian.diagnostics.noisy-neighbour-jira-plugin");
        }
        this.waitForPluginToBeEnabled(enabled);
    }

    private void waitForPluginToBeEnabled(boolean enabled) {
        Awaitility.await((String)("waiting for plugin to be " + (enabled ? "enabled : " : "disabled : ") + "com.atlassian.diagnostics.noisy-neighbour-jira-plugin")).atMost(60L, TimeUnit.SECONDS).pollInterval(Duration.FIVE_HUNDRED_MILLISECONDS).until(() -> this.isPluginEnabled(enabled));
    }

    private boolean isPluginEnabled(boolean enabled) {
        return this.getBackdoor().plugins().getPlugin("com.atlassian.diagnostics.noisy-neighbour-jira-plugin").map(plugin -> plugin.getEnabled() == enabled).orElse(false);
    }

    @Test
    @EnableAnalytics
    public void enablingPlugin_shouldEmitAnalyticsEvents() {
        this.setNoisyNeighbourPluginEnabled(true);
        this.awaitFirstAnalyticsEvent(TestAtlassianPluginJmxMetrics.counterNamed("plugin.enabled.counter"));
    }

    @Test
    @EnableAnalytics
    public void disablingPlugin_shouldEmitAnalyticsEvents() {
        this.setNoisyNeighbourPluginEnabled(false);
        this.awaitFirstAnalyticsEvent(TestAtlassianPluginJmxMetrics.counterNamed("plugin.disabled.counter"));
    }

    private static Matcher<Map<String, String>> counterNamed(String name) {
        return Matchers.allOf((Matcher)Matchers.hasKey((Object)"count"), (Matcher)Matchers.hasEntry((Object)"name", (Object)name), (Matcher)Matchers.hasEntry((Object)"type", (Object)"counter"));
    }
}

