/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import com.google.common.collect.ImmutableList;
import com.jayway.awaitility.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestCustomFieldIndexerJmxMetrics
extends BaseJmxMetricsTest {
    private static final Duration METRICS_TIMEOUT = new Duration(3L, TimeUnit.SECONDS);
    private static final String CUSTOM_FIELD_NAME = "ITA1";
    private static final String CUSTOM_FIELD_ID = "customfield_10000";
    private static final String PROJECT_NAME = "Homosapiens";
    private static final String PROJECT_KEY = "HSP";
    private static final String PLUGIN_KEY = "com.atlassian.jira.dev.func-test-plugin";
    @Rule
    public BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);

    @Before
    public void setup() {
        this.createCustomFieldWithSlowFieldIndexer(PROJECT_NAME);
        this.forceFieldIndexingForProject(PROJECT_KEY);
    }

    @Test
    public void fieldIndexerWithStats_emitsMetrics() {
        this.waitUntil(this::jmxContainsCustomFieldIndexerMetrics, METRICS_TIMEOUT);
    }

    @Test
    @EnableAnalytics
    public void fieldIndexerWithStats_shouldEmitAnalyticsEvents() {
        this.awaitFirstAnalyticsEvent(this.constructExpectedAnalytics("indexing.field.addIndex"));
        this.awaitFirstAnalyticsEvent(this.constructExpectedAnalytics("indexing.field.isFieldIndexableForIssue"));
    }

    private boolean jmxContainsCustomFieldIndexerMetrics() {
        List<String> jmxBeans = this.getJmxBeans();
        ImmutableList expectedJmxMetrics = ImmutableList.of((Object)this.constructExpectedJmxMetric("addIndex"), (Object)this.constructExpectedJmxMetric("isFieldIndexableForIssue"));
        return jmxBeans.containsAll((Collection<?>)expectedJmxMetrics);
    }

    private void createCustomFieldWithSlowFieldIndexer(String projectName) {
        String customFieldDescription = "Test ACF 1";
        String customFieldType = "com.atlassian.jira.plugin.system.customfieldtypes:textfield";
        String customFieldSearcherKey = "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher";
        String fieldId = this.backdoor.customFields().createCustomField(CUSTOM_FIELD_NAME, "Test ACF 1", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher");
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME);
        this.backdoor.fieldConfiguration().associateCustomFieldWithProject(fieldId, projectName);
    }

    private void forceFieldIndexingForProject(String projectKey) {
        this.backdoor.issues().createIssue(projectKey, "issue summary here");
    }

    private Matcher<Map<String, String>> constructExpectedAnalytics(String metricName) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)metricName), (Matcher)Matchers.hasEntry((Object)"tags.fieldId", (Object)CUSTOM_FIELD_ID), (Matcher)Matchers.hasKey((Object)"tags.fieldName"), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"tags.fieldName"), (Matcher)Matchers.containsString((String)CUSTOM_FIELD_ID))), (Matcher)Matchers.hasEntry((Object)"tags.fromPluginKey", (Object)PLUGIN_KEY), (Matcher)Matchers.hasEntry((Object)"type", (Object)"timer"));
    }

    private String constructExpectedJmxMetric(String metricName) {
        return "com.atlassian.jira:category00=indexing,category01=field,name=" + metricName + ",tag.fieldId=" + CUSTOM_FIELD_ID + ",tag.fieldName=" + CUSTOM_FIELD_NAME + ",tag.fromPluginKey=" + PLUGIN_KEY + ",type=metrics";
    }
}

