/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import com.jayway.awaitility.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestCustomFieldSearcherJmxMetrics
extends BaseJmxMetricsTest {
    @Rule
    public BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);
    private static final Duration STATUS_TIMEOUT = new Duration(3L, TimeUnit.SECONDS);

    @Test
    public void customFieldSearcher_emitsMetrics() {
        String cfName = "ITA1";
        String cfDescription = "Test ITA 1";
        String cfType = "com.atlassian.jira.plugin.system.customfieldtypes:textfield";
        String cfSearcherKey = "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher";
        String fieldId = this.backdoor.customFields().createCustomField("ITA1", "Test ITA 1", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher");
        this.backdoor.screens().addFieldToScreen("Default Screen", "ITA1");
        this.backdoor.fieldConfiguration().associateCustomFieldWithProject(fieldId, "Homosapiens");
        List customFields = this.backdoor.customFields().getCustomFields();
        MatcherAssert.assertThat((Object)customFields, (Matcher)CoreMatchers.hasItem((Object)new CustomFieldResponse("ITA1", fieldId, "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "Test ITA 1", "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher", "ITA1", "Test ITA 1")));
        ParsedResponse<String> searchersResponse = this.backdoor.searchersClient().getSearchersResponse("ITA1 ~ randomText");
        Assert.assertEquals((long)200L, (long)searchersResponse.statusCode);
        this.waitUntil(this::jmxContainsCustomFieldSearcherMetrics, STATUS_TIMEOUT);
    }

    private boolean jmxContainsCustomFieldSearcherMetrics() {
        List<String> jmxBeans = this.getJmxBeans();
        return jmxBeans.contains("com.atlassian.jira:category00=customFields,name=searcher,tag.customFieldName=ITA1,tag.fromPluginKey=com.atlassian.jira.dev.func-test-plugin,tag.methodName=getViewHtml,tag.searcherClassName=com.atlassian.jira.dev.customfields.SlowTextSearcher,type=metrics") && jmxBeans.contains("com.atlassian.jira:category00=customFields,name=searcher,tag.customFieldName=ITA1,tag.fromPluginKey=com.atlassian.jira.dev.func-test-plugin,tag.methodName=getSearchHtml,tag.searcherClassName=com.atlassian.jira.dev.customfields.SlowTextSearcher,type=metrics");
    }
}

