/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestSearchJmxMetrics
extends BaseJmxMetricsTest {
    @Rule
    public BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);
    private static final String EXPECTED_JMX_SEARCH_METRIC_PREFIX = "com.atlassian.jira:category00=search,name=index,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin";
    private static final String EXPECTED_JMX_SEARCH_METRIC_OPTION = "tag.query=+____";
    private static final String EXPECTED_JMX_SEARCH_METRIC_SUFFIX = "type=metrics";
    private static final String EXPECTED_JMX_SEARCH_METRIC = "com.atlassian.jira:category00=search,name=index,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin,type=metrics";
    private static final String PUBLIC_API_SEARCH = "PUBLIC_API_SEARCH";
    private static final String INTERNAL_SEARCH = "INTERNAL_SEARCH";

    @Test
    public void internalIssueSearch_emitsMetrics() {
        this.startNoisyNeighbourOperation(INTERNAL_SEARCH);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItem((Object)EXPECTED_JMX_SEARCH_METRIC));
        });
    }

    @Test
    public void publicIssueSearch_emitsMetrics() {
        this.startNoisyNeighbourOperation(PUBLIC_API_SEARCH);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItem((Object)EXPECTED_JMX_SEARCH_METRIC));
        });
    }

    @Test
    public void publicIssueSearch_emitsMetric_withOptionalTags() {
        this.jmxNoisyNeighbourRule.enableOptionalField("search.index", "query");
        this.startNoisyNeighbourOperation(PUBLIC_API_SEARCH);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            MatcherAssert.assertThat(jmxBeans, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"com.atlassian.jira:category00=search,name=index,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin,"), CoreMatchers.containsString((String)EXPECTED_JMX_SEARCH_METRIC_OPTION), CoreMatchers.containsString((String)EXPECTED_JMX_SEARCH_METRIC_SUFFIX)})));
        });
    }
}

