/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import javax.inject.Inject;
import net.sourceforge.jwebunit.TestContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class Test500Page
extends BaseJiraFuncTest {
    private static final String ERRONEOUS_SERVLET_URL = "/plugins/servlet/functest-throw-exception";
    private static final String CAUSE_HEADER = "Cause";
    private static final String EXCEPTION_TRACE_PART = "at com.atlassian";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private EnvironmentUtils environmentUtils;

    @Before
    public void setUpTest() {
        this.administration.restoreData("Test500Page.xml");
        this.navigation.gotoDashboard();
        this.setShowStackTrace(true);
    }

    @Test
    @DevMode(enabled=false)
    public void testAdminUserSeesExtendedInfoInProductionMode() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextSequence(this.locator.page(), "ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.textAssertions.assertTextSequence(this.locator.page(), "Param1", "paramKey");
        this.textAssertions.assertTextSequence(this.locator.page(), "Param2", "paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService", "123");
        this.textAssertions.assertTextSequence(this.locator.page(), "popserver:", "fake server");
        this.textAssertions.assertTextSequence(this.locator.page(), "handler.params:", "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.textAssertions.assertTextSequence(this.locator.page(), "forwardEmail:", "fake@example.com");
        this.textAssertions.assertTextSequence(this.locator.page(), "handler:", "Create a new issue or add a comment to an existing issue");
    }

    @Test
    @DevMode(enabled=false)
    public void testAnonymousUserDoesNotSeeAnyInfoInProductionMode() {
        this.navigation.logout();
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextNotPresent(this.locator.page(), "ParamListeners");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Param1:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "paramKey");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Param2:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "paramValue");
        this.assertServiceHeaderNotPresent("Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService");
        this.assertServiceParamsNotVisible();
    }

    @Test
    @DevMode(enabled=false)
    public void testRegularUserDoesNotSeeAnyInfoInProductionMode() {
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextNotPresent(this.locator.page(), "ParamListeners");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Param1:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "paramKey");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Param2:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "paramValue");
        this.assertServiceHeaderNotPresent("Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService");
        this.assertServiceParamsNotVisible();
    }

    @Test
    @DevMode
    public void testRegularUserSeesExtendedInfoInDevMode() {
        this.setShowStackTrace(false);
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextPresent(this.locator.page(), "Server ID");
        this.textAssertions.assertTextPresent(this.locator.page(), "File Paths");
        this.textAssertions.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        this.textAssertions.assertTextPresent(this.locator.page(), "-Xmx");
    }

    @Test
    public void test500PageContainsMemoryAndInputArgsInfo() {
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        if (this.environmentUtils.isJvmWithPermGen()) {
            this.textAssertions.assertTextPresent(this.locator.page(), "Used PermGen Memory");
            this.textAssertions.assertTextPresent(this.locator.page(), "Free PermGen Memory");
        }
        this.textAssertions.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Unable to determine, this requires running JDK 1.5 and higher.");
    }

    @Test
    public void testExternalUserManagement() {
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextPresent(this.locator.page(), "External user management");
    }

    @Test
    public void testHtmlEscapingOfErrors() throws Exception {
        String badHtml = "<body onload=alert('XSSATTACK')>";
        String badHtmlEscaped = "%3Cbody%20onload=alert('XSSATTACK')%3E";
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + "/secure/Dashboard!default" + badHtmlEscaped + ".jspa");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        webClient.setExceptionsThrownOnErrorStatus(false);
        WebResponse response = webClient.sendRequest((WebRequest)request);
        String responseText = response.getText();
        Assert.assertFalse((String)"Found bad HTML in the response", (responseText.indexOf(badHtml) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAdministratorDoesntSeeContactYourAdmin() {
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextPresent(this.locator.page(), "Raise an issue for the Support team");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Jira Administrator contact form");
    }

    @Test
    public void testNonAdministratorSeesContactYourAdmin() {
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextPresent(this.locator.page(), "to your Jira Administrator");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Raise an issue for the Support team");
    }

    @Test
    public void testSystemAdministratorCanSeeSysAdminOnlyProperties() {
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Contact your System Administrator to discover file path information.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Contact your System Administrator to discover this property value.");
        this.textAssertions.assertTextSequence(this.locator.page(), "Server ID", "ABN9-RZYJ-WI2T-37UF");
        this.textAssertions.assertTextSequence(this.locator.page(), "server logs", "Support ZIP", " technical details");
        this.textAssertions.assertTextSequence(this.locator.page(), "File Paths", "atlassian-jira.log", "entityengine.xml");
        this.textAssertions.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        this.textAssertions.assertTextPresent(this.locator.page(), "-D");
        this.textAssertions.assertTextPresent(this.locator.page(), "Current Working Directory");
    }

    @Test
    @DevMode(enabled=false)
    public void testNonSystemAdministratorDoesntSeeFilePaths() {
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextNotPresent(this.locator.page(), "attach the application server log file");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "atlassian-jira.log");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Server ID");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "File Paths");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Current Working Directory");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "JVM Input Arguments");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "-Xmx");
        this.navigation.login("admin_non_sysadmin", "admin_non_sysadmin");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.textAssertions.assertTextNotPresent("File Paths");
        this.textAssertions.assertTextSequence(this.locator.page(), "Server ID", "ABN9-RZYJ-WI2T-37UF", "Current Working Directory", "Contact your System Administrator to discover this property value.", "JVM Input Arguments", "Contact your System Administrator to discover this property value.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "-Xmx");
    }

    @Test
    @DevMode(enabled=false)
    public void testAnonymousUserDoesntSeeCauseInProductionMode() {
        this.navigation.logout();
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertCauseNotVisible();
    }

    @Test
    @DevMode
    public void testAnonymousUserSeesFullCauseInDevMode() {
        this.navigation.logout();
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertFullCauseTraceVisible();
    }

    @Test
    @DevMode(enabled=false)
    public void testNormalUserDoesntSeeCauseInProductionMode() {
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertCauseNotVisible();
    }

    @Test
    @DevMode
    public void testNormalUserSeesFullCauseInDevMode() {
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertFullCauseTraceVisible();
    }

    @Test
    @DevMode(enabled=false)
    public void testAdminSeesFullCauseInProductionMode() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertFullCauseTraceVisible();
    }

    @Test
    @DevMode
    public void testAdminSeesFullCauseInDevMode() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertFullCauseTraceVisible();
    }

    @Test
    @DevMode(enabled=false)
    public void testAnonymousUserDoesntSeeCauseInProductionModeToggleOff() {
        this.setShowStackTrace(false);
        this.navigation.logout();
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertCauseNotVisible();
    }

    @Test
    @DevMode
    public void testAnonymousUserSeesShortCauseInDevModeToggleOff() {
        this.setShowStackTrace(false);
        this.navigation.logout();
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertShortCauseTraceVisible();
    }

    @Test
    @DevMode(enabled=false)
    public void testNormalUserDoesntSeeCauseInProductionModeToggleOff() {
        this.setShowStackTrace(false);
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertCauseNotVisible();
    }

    @Test
    @DevMode
    public void testNormalUserSeesShortCauseInDevModeToggleOff() {
        this.setShowStackTrace(false);
        this.navigation.login("bob", "bob");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertShortCauseTraceVisible();
    }

    @Test
    @DevMode(enabled=false)
    public void testAdminSeesShortCauseInProductionModeToggleOff() {
        this.setShowStackTrace(false);
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertShortCauseTraceVisible();
    }

    @Test
    @DevMode
    public void testAdminSeesShortCauseInDevModeToggleOff() {
        this.setShowStackTrace(false);
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        this.assertShortCauseTraceVisible();
    }

    private void setShowStackTrace(boolean value) {
        this.backdoor.applicationProperties().setOption("jira.option.stacktraceOnErrorpage", value);
    }

    private void assertServiceHeaderPresent(String serviceName, String serviceClass, String delay) {
        this.textAssertions.assertTextSequence(this.locator.page(), "Services", serviceName, serviceClass, "0 0 0/2 * * ?");
    }

    private void assertServiceHeaderNotPresent(String serviceName, String serviceClass) {
        this.textAssertions.assertTextNotPresent(serviceName);
        this.textAssertions.assertTextNotPresent(serviceClass);
    }

    private void assertServiceParamsNotVisible() {
        this.textAssertions.assertTextNotPresent(this.locator.page(), "usessl:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "No SSL");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "popserver:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "fake server");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "handler.params:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "forwardEmail:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "fake@example.com");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "handler:");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Create a new issue or add a comment to an existing issue");
    }

    private void assertFullCauseTraceVisible() {
        this.textAssertions.assertTextPresent(this.locator.page(), CAUSE_HEADER);
        this.textAssertions.assertTextPresent(this.locator.page(), EXCEPTION_TRACE_PART);
    }

    private void assertShortCauseTraceVisible() {
        this.textAssertions.assertTextPresent(this.locator.page(), CAUSE_HEADER);
        this.textAssertions.assertTextNotPresent(this.locator.page(), EXCEPTION_TRACE_PART);
    }

    private void assertCauseNotVisible() {
        this.textAssertions.assertTextNotPresent(this.locator.page(), CAUSE_HEADER);
        this.textAssertions.assertTextNotPresent(this.locator.page(), EXCEPTION_TRACE_PART);
    }
}

