/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestBasic
extends BaseJiraFuncTest {
    private static final String NEW_FEATURE_I18N_KEY = "jira.translation.issuetype.newfeature.name";
    private static final String BUG_I18N_KEY = "jira.translation.issuetype.bug.name";
    private static final String IMPROVEMENT_I18N_KEY = "jira.translation.issuetype.improvement.name";
    private static final String TASK_I18N_KEY = "jira.translation.issuetype.task.name";
    private static final String ANY_TYPE_I18N_KEY = "admin.schemecontext.anyissuetype";
    private static final String NO_COMMENTS_I18N_KEY = "viewissue.nocomments";
    private static final String INVALID_DUE_DATE_I18N_KEY = "createissue.error.invalid.due.date";
    private static final String CREATE_I18N_KEY = "common.words.create";
    private static final String ERROR_I18N_KEY = "common.words.errors";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @After
    public void revertLocaleChanges() {
        this.navigation.userProfile().changeUserLanguageToJiraDefault();
    }

    @Test
    public void testI18NDates() throws IOException {
        this.setLocaleTo("Deutsch (Deutschland)");
        this.createIssueInGermanWithDueDate("25/Dez/05");
        this.tester.assertTextPresent(this.getGermanTranslation(NO_COMMENTS_I18N_KEY));
        this.createIssueInGermanWithDueDate("25/Dec/05");
        this.tester.assertTextPresent(this.getGermanTranslation(INVALID_DUE_DATE_I18N_KEY).substring(0, 10));
    }

    @Test
    public void testIssueConstantTranslations() {
        this.setLocaleTo("Deutsch (Deutschland)");
        this.updateBugTranslationWith("", "");
        this.browseToCustomFieldAdd();
        this.tester.assertTextPresent(this.getGermanTranslation(ANY_TYPE_I18N_KEY));
        this.tester.assertTextPresent(this.getGermanTranslation(BUG_I18N_KEY));
        this.tester.assertTextPresent(this.getGermanTranslation(IMPROVEMENT_I18N_KEY));
        this.tester.assertTextPresent(this.getGermanTranslation(NEW_FEATURE_I18N_KEY));
        this.tester.assertTextPresent(this.getGermanTranslation(TASK_I18N_KEY));
        this.updateBugTranslationWith("bugenzee", "bugenzee desc");
        this.browseToCustomFieldAdd();
        this.textAssertions.assertTextPresent(this.locator.css(".jiraform"), "bugenzee");
        this.textAssertions.assertTextNotPresent(this.locator.css(".jiraform"), this.getGermanTranslation(ERROR_I18N_KEY));
    }

    private void updateBugTranslationWith(String name, String desc) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.clickLink("translate_link");
        this.tester.setWorkingForm("update");
        this.tester.setFormElement("jira.translation.Vorgangstyp.1.name", name);
        this.tester.setFormElement("jira.translation.Vorgangstyp.1.desc", desc);
        this.tester.submit();
    }

    private void browseToCustomFieldAdd() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:textarea");
        this.tester.submit("nextBtn");
    }

    private void createIssueInGermanWithDueDate(String dueDate) {
        this.navigation.issue().goToCreateIssueForm("homosapien", this.getBackdoor().i18n().getText(BUG_I18N_KEY, "de_DE"));
        this.tester.setWorkingForm("issue-create");
        WebForm form = this.tester.getDialog().getForm();
        form.setParameter("duedate", dueDate);
        form.setParameter("summary", "test issue");
        Assert.assertEquals((Object)this.getGermanTranslation(CREATE_I18N_KEY), (Object)form.getButtonWithID("issue-create-submit").getValue());
        this.tester.submit("Create");
    }

    private void setLocaleTo(String localeName) {
        this.navigation.userProfile().changeUserLanguage(localeName);
    }

    private String getGermanTranslation(String i18nKey) {
        return this.getBackdoor().i18n().getText(i18nKey, "de_DE");
    }
}

