/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.jira.functest.framework.SkipSetBaseUrl;
import com.atlassian.jira.functest.framework.SkipSetup;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.setup.PostgresContainer;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SkipCacheCheck;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.jayway.awaitility.Awaitility;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SETUP, Category.DATABASE})
@SkipSetup
@SkipCacheCheck
@SkipSetBaseUrl
public class TestDatabaseConnectionLost
extends BaseInProductDiagnosticsTest {
    private JiraSetupInstanceHelper jiraSetupInstanceHelper;

    @Override
    @Before
    public void setUp() {
        this.jiraSetupInstanceHelper = new JiraSetupInstanceHelper(this.tester, this.environmentData);
    }

    @Test
    public void testAll() {
        PostgresContainer postgresContainer = new PostgresContainer();
        postgresContainer.start();
        this.configureTestJdbc(postgresContainer);
        this.jiraSetupInstanceHelper.ensureJIRAIsReadyToGo();
        this.enableIPDFeature();
        this.assertDatabaseStateIs(DatabaseConnectionStateService.DatabaseConnectionState.CONNECTED);
        this.assertDatabaseErrorCountIs(errors -> Assertions.assertThat((long)errors).isEqualTo(0L));
        postgresContainer.stopForRestart();
        this.assertDatabaseStateIs(DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED);
        this.assertDatabaseErrorCountIs(errors -> Assertions.assertThat((long)errors).isPositive());
        postgresContainer.startForRestart();
        this.assertDatabaseStateIs(DatabaseConnectionStateService.DatabaseConnectionState.CONNECTED);
    }

    private void assertDatabaseStateIs(DatabaseConnectionStateService.DatabaseConnectionState expectedState) {
        Awaitility.await().atMost(90L, TimeUnit.SECONDS).until(() -> {
            Object valueFromJmx = this.getRemotelyJmxObjectWithValue("com.atlassian.jira:type=metrics,category00=db,category01=connection,category02=state,name=value").get("Value");
            Assertions.assertThat((Object)valueFromJmx).isNotNull();
            Assertions.assertThat((Object)valueFromJmx).isInstanceOf(Double.class);
            Double dbState = (Double)valueFromJmx;
            Assertions.assertThat((Double)dbState).isEqualByComparingTo((Comparable)Double.valueOf(expectedState.getValue()));
        });
    }

    private void assertDatabaseErrorCountIs(LongConsumer dbErrorsAssertion) {
        Awaitility.await().atMost(90L, TimeUnit.SECONDS).until(() -> {
            Object countFromJmx = this.getRemotelyJmxObjectWithStats("com.atlassian.jira:type=metrics,category00=db,category01=connection,category02=failures,name=counter").get("Count");
            Assertions.assertThat((Object)countFromJmx).isNotNull();
            Assertions.assertThat((Object)countFromJmx).isInstanceOf(Long.class);
            Long errorCount = (Long)countFromJmx;
            dbErrorsAssertion.accept(errorCount);
        });
    }

    private void configureTestJdbc(PostgresContainer postgresContainer) {
        this.navigation.gotoPage("/secure/SetupDatabase!default.jspa");
        this.jiraSetupInstanceHelper.connectToTestDatabase(postgresContainer);
    }
}

