/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.SkipSetBaseUrl;
import com.atlassian.jira.functest.framework.SkipSetup;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PermissionSchemesMatcher;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.IMPORT_EXPORT, Category.SETUP, Category.ISSUE_TYPES, Category.REFERENCE_PLUGIN})
@SkipSetup
@SkipSetBaseUrl
@HttpUnitConfiguration(enableScripting=false)
public class TestDefaultJiraDataFromInstall
extends BaseJiraFuncTest {
    @Inject
    private Assertions assertions;
    @Inject
    private Administration administration;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage htmlPage;
    private TableAssertions tableAssertions;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testDefaultJiraData() throws SAXException {
        JiraSetupInstanceHelper jiraSetupInstanceHelper = new JiraSetupInstanceHelper(this.tester, this.environmentData);
        if (!jiraSetupInstanceHelper.isJiraSetup()) {
            jiraSetupInstanceHelper.ensureJIRAIsReadyToGo();
            this.tableAssertions = this.assertions.getTableAssertions();
            this._testEnterpriseDefaultJiraPermissions();
            this._testEnterpriseDefaultNotificationSchemes();
            this._testEnterpriseDefaultScreenSchemes();
            this._testEnterpriseDefaultIssueTypeScreenSchemes();
            this._testEnterpriseDefaultEventTypes();
            this._testEnterpriseDefaultFieldsVisibility();
            this._testDefaultTimeTrackingOptions();
            this._testDefaultSubTaskOptions();
            this._testDefaultIssueTypes();
            this._testWikiRendererAsDefaultForAllRenderableFields();
        } else {
            Assert.fail((String)"TestDefaultJiraDataFromInstall needs to be prior to being setup");
        }
    }

    private void _testWikiRendererAsDefaultForAllRenderableFields() {
        String[] renderableFields;
        for (String fieldName : renderableFields = new String[]{"Comment", "Description", "Environment", "Log Work"}) {
            Assert.assertEquals((Object)"Wiki Style Renderer", (Object)this.administration.fieldConfigurations().defaultFieldConfiguration().getRenderer(fieldName));
        }
    }

    private void _testDefaultSubTaskOptions() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "Sub-Tasks are currently turned", "ON", "You can manage your sub-tasks as part of standard issue types");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//td[@class='jiraformbody']", "Disable");
    }

    private void _testDefaultIssueTypes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        WebTable issueTypesTable = this.tester.getDialog().getWebTableBySummaryOrId("issue-types-table");
        Assert.assertEquals((long)issueTypesTable.getRowCount(), (long)1L);
    }

    private void _testDefaultTimeTrackingOptions() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.TIMETRACKING);
        this.tester.assertElementPresent("deactivate_submit");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "To change these values deactivate and then reactivate Time Tracking", "The number of working hours per day is", "8", "The number of working days per week is", "5", "Time estimates will be displayed in the following format:", "pretty (e.g. 4 days, 4 hours, 30 minutes)", "The current default unit for time tracking is", "minute", "Copying of comments to work description is currently", "enabled");
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Legacy mode is currently");
    }

    public void _testEnterpriseDefaultFieldsVisibility() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-Default Field Configuration");
        this.tester.assertTextPresent("View Field Configuration");
        this.assertField("Affects Version/s", 0, false);
        this.assertField("Assignee", 1, false);
        this.assertField("Attachment", 2, false);
        this.assertField("Component/s", 4, false);
        this.assertField("Description", 5, false);
        this.assertField("Due Date", 6, false);
        this.assertField("Environment", 7, false);
        this.assertField("Fix Version/s", 8, false);
        this.assertField("Priority", 10, false);
        this.assertField("Reporter", 11, false);
        this.assertField("Resolution", 12, false);
        this.assertField("Security Level", 13, false);
    }

    private void assertField(String field, int id, boolean hide) {
        this.tester.assertTextPresent(field);
        if (hide) {
            this.tester.assertLinkPresent("hide_" + id);
        }
    }

    public void _testEnterpriseDefaultJiraPermissions() throws SAXException {
        PermissionSchemeBean permissions = this.backdoor.permissionSchemes().getAssignedPermissions(0L);
        this.assertAdminRole(permissions, ProjectPermissions.ADMINISTER_PROJECTS);
        this.assertAnyoneRole(permissions, ProjectPermissions.BROWSE_PROJECTS);
        this.assertAnyoneRole(permissions, ProjectPermissions.VIEW_READONLY_WORKFLOW);
        this.logger.log((Object)"Checking issue permissions");
        this.assertAnyoneRole(permissions, ProjectPermissions.ASSIGNABLE_USER);
        this.assertAnyoneRole(permissions, ProjectPermissions.ASSIGN_ISSUES);
        this.assertAnyoneRole(permissions, ProjectPermissions.CLOSE_ISSUES);
        this.assertAnyoneRole(permissions, ProjectPermissions.CREATE_ISSUES);
        this.assertAdminRole(permissions, ProjectPermissions.DELETE_ISSUES);
        this.assertAnyoneRole(permissions, ProjectPermissions.EDIT_ISSUES);
        this.assertAnyoneRole(permissions, ProjectPermissions.LINK_ISSUES);
        this.assertAdminRole(permissions, ProjectPermissions.MODIFY_REPORTER);
        this.assertAnyoneRole(permissions, ProjectPermissions.MOVE_ISSUES);
        this.assertAnyoneRole(permissions, ProjectPermissions.RESOLVE_ISSUES);
        this.assertAnyoneRole(permissions, ProjectPermissions.SCHEDULE_ISSUES);
        this.assertNoRole(permissions, ProjectPermissions.SET_ISSUE_SECURITY);
        this.assertAnyoneRole(permissions, ProjectPermissions.TRANSITION_ISSUES);
        this.logger.log((Object)"Checking edit comments");
        this.assertAnyoneRole(permissions, ProjectPermissions.ADD_COMMENTS);
        this.assertAdminRole(permissions, ProjectPermissions.DELETE_ALL_COMMENTS);
        this.assertAnyoneRole(permissions, ProjectPermissions.DELETE_OWN_COMMENTS);
        this.assertAdminRole(permissions, ProjectPermissions.EDIT_ALL_COMMENTS);
        this.assertAnyoneRole(permissions, ProjectPermissions.EDIT_OWN_COMMENTS);
        this.logger.log((Object)"Checking time tracking permissions");
        this.assertAdminRole(permissions, ProjectPermissions.DELETE_ALL_WORKLOGS);
        this.assertAnyoneRole(permissions, ProjectPermissions.DELETE_OWN_WORKLOGS);
        this.assertAdminRole(permissions, ProjectPermissions.EDIT_ALL_WORKLOGS);
        this.assertAnyoneRole(permissions, ProjectPermissions.EDIT_OWN_WORKLOGS);
        this.assertAnyoneRole(permissions, ProjectPermissions.WORK_ON_ISSUES);
        this.logger.log((Object)"Checking attachments permissions");
        this.assertAnyoneRole(permissions, ProjectPermissions.CREATE_ATTACHMENTS);
        this.assertAdminRole(permissions, ProjectPermissions.DELETE_ALL_ATTACHMENTS);
        this.assertAnyoneRole(permissions, ProjectPermissions.DELETE_OWN_ATTACHMENTS);
        this.logger.log((Object)"Checking voters & watchers permissions");
        this.assertAdminRole(permissions, ProjectPermissions.MANAGE_WATCHERS);
        this.assertAnyoneRole(permissions, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS);
        this.logger.log((Object)"Checking Global Permissions");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        WebTable globalPermissionsTable = this.tester.getDialog().getResponse().getTableWithID("global_perms");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 1, 0, "Jira System Administrators");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 1, 1, "jira-administrators");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 2, 0, "Jira Administrators");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 2, 1, "jira-administrators");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 3, 0, "Browse Users");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 3, 1, "jira-software-users");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 4, 0, "Create Shared Objects");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 4, 1, "jira-software-users");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 5, 0, "Manage Group Filter Subscriptions");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 5, 1, "jira-software-users");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 6, 0, "Bulk Change");
        this.tableAssertions.assertTableCellHasText(globalPermissionsTable, 6, 1, "jira-software-users");
    }

    private void _testEnterpriseDefaultNotificationSchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        String atl_token = this.htmlPage.getXsrfToken();
        XPathLocator nameLocator = new XPathLocator(this.tester, "//*[@href=\"EditNotifications!default.jspa?atl_token=" + atl_token + "&schemeId=10000\"]");
        this.textAssertions.assertTextPresent(nameLocator, "Default Notification Scheme");
    }

    private void _testEnterpriseDefaultScreenSchemes() {
        String[] strings = new String[]{"Default Screen Scheme", "Default Screen Scheme"};
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }

    private void _testEnterpriseDefaultIssueTypeScreenSchemes() {
        String[] strings = new String[]{"Default Issue Type Screen Scheme", "The default issue type screen scheme"};
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }

    private void _testEnterpriseDefaultEventTypes() {
        String[] strings = new String[]{"Issue Created", "This is the &#39;issue created&#39; event.", "Issue Updated", "This is the &#39;issue updated&#39; event.", "Issue Assigned", "This is the &#39;issue assigned&#39; event.", "Issue Resolved", "This is the &#39;issue resolved&#39; event.", "Issue Closed", "This is the &#39;issue closed&#39; event.", "Issue Commented", "This is the &#39;issue commented&#39; event.", "Issue Comment Edited", "This is the &#39;issue comment edited&#39; event.", "Issue Reopened", "This is the &#39;issue reopened&#39; event.", "Issue Deleted", "This is the &#39;issue deleted&#39; event.", "Issue Moved", "This is the &#39;issue moved&#39; event.", "Work Logged On Issue", "This is the &#39;work logged on issue&#39; event.", "Work Started On Issue", "This is the &#39;work started on issue&#39; event.", "Work Stopped On Issue", "This is the &#39;work stopped on issue&#39; event.", "Issue Worklog Updated", "This is the &#39;issue worklog updated&#39; event.", "Issue Worklog Deleted", "This is the &#39;issue worklog deleted&#39; event.", "Generic Event", "This is the &#39;generic event&#39; event."};
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }

    private void assertAdminRole(PermissionSchemeBean permissions, ProjectPermissionKey permissionsKey) {
        this.assertHasPermission(permissions, permissionsKey, JiraPermissionHolderType.PROJECT_ROLE, Long.toString(10002L));
    }

    private void assertAnyoneRole(PermissionSchemeBean permissions, ProjectPermissionKey permissionsKey) {
        this.assertHasPermission(permissions, permissionsKey, JiraPermissionHolderType.APPLICATION_ROLE, "");
    }

    private void assertNoRole(PermissionSchemeBean permissions, ProjectPermissionKey permissionsKey) {
        this.assertHasNoPermission(permissions, permissionsKey, JiraPermissionHolderType.PROJECT_ROLE, Long.toString(10002L));
        this.assertHasNoPermission(permissions, permissionsKey, JiraPermissionHolderType.APPLICATION_ROLE, "");
        this.assertHasNoPermission(permissions, permissionsKey, JiraPermissionHolderType.PROJECT_ROLE, Long.toString(10001L));
    }

    private void assertHasPermission(PermissionSchemeBean permissions, ProjectPermissionKey permissionsKey, JiraPermissionHolderType type, String parameter) {
        this.assertPermission(permissions, permissionsKey, type, parameter, true);
    }

    private void assertHasNoPermission(PermissionSchemeBean permissions, ProjectPermissionKey permissionsKey, JiraPermissionHolderType type, String parameter) {
        this.assertPermission(permissions, permissionsKey, type, parameter, false);
    }

    private void assertPermission(PermissionSchemeBean permissions, ProjectPermissionKey permissionsKey, JiraPermissionHolderType type, String parameter, boolean hasPermission) {
        String errorMessage = String.format("Does not have permission '%s' with type '%s' and value '%s'", permissionsKey.permissionKey(), type.getKey(), parameter);
        boolean matches = PermissionSchemesMatcher.hasPermission(permissionsKey.permissionKey(), type.getKey(), parameter).matches((Object)permissions);
        Assert.assertEquals((String)errorMessage, (Object)matches, (Object)hasPermission);
    }

    private void assertDevRole(WebTable permissionsTable, int row) {
        this.tableAssertions.assertTableCellHasText(permissionsTable, row, 1, "(Developers)");
    }
}

