/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.SkipSetBaseUrl;
import com.atlassian.jira.functest.framework.SkipSetup;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SkipCacheCheck;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SETUP})
@HttpUnitConfiguration(throwOnErrorStatus=false, enableScripting=false)
@SkipSetup
@SkipCacheCheck
@SkipSetBaseUrl
public class TestJohnsonFiltersWhileNotSetup
extends BaseJiraFuncTest {
    private static final Logger log = LoggerFactory.getLogger(TestJohnsonFiltersWhileNotSetup.class);
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testAll() throws IOException {
        this.shouldReturnStatus503();
        this.shouldDisplaySetupPage();
    }

    private void shouldReturnStatus503() throws IOException {
        this.assert503Only("/si/whatever");
        this.assert503Only("/sr/whatever");
        this.assert503Only("/download/*");
        this.assert503Only("/plugins/servlet/*");
        this.assert503Only("/secure/attachment/blah-tricky.gif");
        this.assert503Only("/rest/some/rest");
        this.assert503Only("/rest/a");
    }

    private void shouldDisplaySetupPage() {
        this.tester.beginAt("/browse/ABC-123");
        WebResponse webResponse = this.tester.getDialog().getResponse();
        Assert.assertEquals((String)"should be a 200 response", (long)200L, (long)webResponse.getResponseCode());
        this.textAssertions.assertTextPresent(this.locator.page(), "configuration");
    }

    private void assert503Only(String atUrl) throws IOException {
        try {
            this.tester.beginAt(atUrl);
        }
        catch (RuntimeException re) {
            log.warn("Not able to properly assert the response code, using crude (websphere) workaround instead");
            Assert.assertTrue((boolean)re.getMessage().contains("IOException"));
            Assert.assertTrue((boolean)re.getMessage().contains("503"));
            return;
        }
        WebResponse webResponse = this.tester.getDialog().getResponse();
        Assert.assertEquals((String)("expected service unavailable response for url: '" + atUrl + "'"), (long)503L, (long)webResponse.getResponseCode());
        Assert.assertEquals((String)("should be no content for this url: '" + atUrl + "'"), (long)0L, (long)webResponse.getText().length());
    }
}

