/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.DashboardControl;
import java.net.URL;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestLoginActions
extends BaseJiraFuncTest {
    private static final String NOT_RECORDED = "Not recorded";
    private static final String NEVER_LOGGED_IN = "Never logged in";
    private static final String AUTHENTICATION_ERR_MSG = "Sorry, your username and password are incorrect - please try again.";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testLogin() {
        this.navigation.login("admin", "admin");
        this.assertRedirectPath(this.getEnvironmentData().getContext() + "/");
    }

    @Test
    public void testLogInAgainGoesToLoginPage() {
        this.navigation.logout();
        this.tester.assertTextPresent("Log in again");
        this.tester.clickLinkWithText("Log in again");
        String url = this.tester.getDialog().getResponse().getURL().getPath();
        Assert.assertTrue((String)("The URL '" + url + "' did not contain 'login.jsp'"), (boolean)url.contains("login.jsp"));
        Assert.assertFalse((String)("The URL '" + url + "' contained 'Dashboard'"), (boolean)url.contains("Dashboard"));
    }

    @Test
    public void testLoginPageWithNoPassword() {
        this.navigation.loginAttempt(null, null);
        this.tester.assertTextPresent(AUTHENTICATION_ERR_MSG);
    }

    @Test
    public void testBadPasswordLogin() {
        this.navigation.loginAttempt("admin", "bad password");
        this.tester.assertTextPresent(AUTHENTICATION_ERR_MSG);
    }

    @Test
    public void testGoodPasswordNoPermission() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.administration.usersAndGroups().removeUserFromGroup("fred", "jira-users");
        this.navigation.logout();
        this.navigation.loginAttempt("fred", "fred");
        this.tester.assertTextPresent("You do not have a permission to log in.");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testLastLoginInfoIsShown() {
        this.administration.restoreData("TestLastLogin.xml");
        this.gotoUserBrowser();
        TableLocator tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.textAssertions.assertTextSequence(tableLocator, "admin", "Just now", "fred", NEVER_LOGGED_IN, "nouserpermission", NEVER_LOGGED_IN);
        this.forceUserLoginAttributesFlush("admin");
        long adminLoginCount = this.backdoor.userProfile().getUserLoginCount("admin");
        this.assertViewUser("admin", true, true, adminLoginCount);
        this.assertViewUser("fred", false, false, null);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("fred", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.textAssertions.assertTextSequence(tableLocator, "admin", "Just now", "fred", "Just now", "nouserpermission", NEVER_LOGGED_IN);
        this.assertViewUser("fred", true, false, 1L);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("fred", "admin");
        this.forceUserLoginAttributesFlush("fred");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.textAssertions.assertTextSequence(tableLocator, "admin", "Just now", "fred", "Just now", "nouserpermission", NEVER_LOGGED_IN);
        this.assertViewUser("fred", true, true, 2L);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("nouserpermission", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.textAssertions.assertTextSequence(tableLocator, "admin", "Just now", "fred", "Just now", "nouserpermission", NEVER_LOGGED_IN);
        this.assertViewUser("fred", true, true, 2L);
        this.assertViewUser("nouserpermission", false, false, null);
    }

    private void forceUserLoginAttributesFlush(String user) {
        try {
            ((DashboardControl)this.backdoor.dashboard().loginAs(user, user + "wrongPass")).emptySystemDashboard();
            Assert.fail((String)"Exception expected in result of failed login");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testCAPTCHALockedOut() {
        this.administration.restoreData("TestLastLogin.xml");
        this.setMaximumLoginAttempts("3");
        this.loginAsAndThenAs("fred", "FAIL", "admin", false, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 1L, 1L);
        this.loginAsAndThenAs("fred", "FAIL", "admin", false, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 2L, 2L);
        this.loginAsAndThenAs("fred", "FAIL", "admin", true, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 3L, 3L);
        this.resetUserLoginCount("fred");
        this.assertViewUserFailedAttempts("fred", true, 0L, 3L);
        this.loginAsAndThenAs("fred", "FAIL", "admin", false, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 1L, 4L);
        this.loginAsAndThenAs("fred", "fred", "admin", false, null);
        this.assertViewUserFailedAttempts("fred", true, 0L, 4L);
        this.navigation.login("admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLinkWithText("fred");
        this.tester.clickLinkWithText("Set Password");
        this.tester.setFormElement("password", "fred");
        this.tester.setFormElement("confirm", "fred");
        this.tester.submit("Update");
        this.assertViewUser("fred", true, false, 1L);
    }

    private void resetUserLoginCount(String userName) {
        this.gotoUserBrowser();
        this.tester.clickLinkWithText("Reset Failed Login Count");
    }

    private void setMaximumLoginAttempts(String howMany) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("title", "jWebTest JIRA installation");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", howMany);
        this.tester.checkCheckbox("captcha", "false");
        this.tester.submit("Update");
    }

    private void gotoUserBrowser() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
    }

    private void loginAsAndThenAs(String userName1, String userName2) {
        this.loginAsAndThenAs(userName1, userName1, userName2, false, null);
    }

    private void loginAsAndThenAs(String userName1, String userName1password, String userName2, boolean requireCaptcha, String errMsg) {
        this.navigation.logout();
        this.navigation.loginAttempt(userName1, userName1password);
        this.assertCAPTCHAShown(requireCaptcha);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            this.tester.assertTextPresent(errMsg);
        }
        this.navigation.logout();
        this.navigation.loginAttempt(userName2, userName2);
    }

    private void assertViewUser(String userName, boolean lastLoginSet, boolean prevLoginSet, Long loginCount) {
        this.tester.gotoPage("secure/admin/user/ViewUser.jspa?name=" + userName);
        this.assertNotRecorded(lastLoginSet, new XPathLocator(this.tester, "//dd[@id='lastLogin']"));
        this.assertNotRecorded(prevLoginSet, new XPathLocator(this.tester, "//dd[@id='previousLogin']"));
        this.assertLoginNumber(loginCount, "loginCount");
    }

    private void assertViewUserFailedAttempts(String userName, boolean lastFailedLoginSet, Long currentFailedCount, Long totalFailedLoginCount) {
        this.tester.gotoPage("secure/admin/user/ViewUser.jspa?name=" + userName);
        this.assertNotRecorded(lastFailedLoginSet, new XPathLocator(this.tester, "//dd[@id='lastFailedLogin']"));
        this.assertLoginNumber(currentFailedCount, "currentFailedLoginCount");
        this.assertLoginNumber(totalFailedLoginCount, "totalFailedLoginCount");
    }

    private void assertLoginNumber(Long currentFailedCount, String fieldName) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//dd[@id='" + fieldName + "']");
        if (currentFailedCount != null) {
            this.textAssertions.assertTextPresent(pathLocator, String.valueOf(currentFailedCount));
        } else {
            Assert.assertEquals((String)("The " + fieldName + " should be Not Recorded"), (Object)NOT_RECORDED, (Object)pathLocator.getText());
        }
    }

    private void assertCAPTCHAShown(boolean requireCaptcha) {
        boolean hasCaptcha = this.tester.getDialog().hasFormParameterNamed("os_captcha");
        String message = "CAPTCHA should " + (requireCaptcha ? "BE" : "NOT BE") + " present";
        Assert.assertEquals((String)message, (Object)requireCaptcha, (Object)hasCaptcha);
    }

    private void assertNotRecorded(boolean lastLoginSet, XPathLocator loc) {
        if (!lastLoginSet) {
            this.textAssertions.assertTextPresent(loc, NOT_RECORDED);
        } else {
            this.textAssertions.assertTextNotPresent(loc, NOT_RECORDED);
        }
    }

    private void assertRedirectPath(String s) {
        URL url = this.tester.getDialog().getResponse().getURL();
        Assert.assertEquals((Object)s, (Object)url.getPath());
    }
}

