/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.meterware.httpunit.WebResponse;
import net.sourceforge.jwebunit.WebTester;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@RestoreBlankInstance
@HttpUnitConfiguration(throwOnErrorStatus=false)
public class TestSeraphAuthType
extends BaseJiraFuncTest {
    @Test
    public void testBasic() throws Exception {
        this.tester.beginAt("/?os_authType=basic");
        WebResponse response = this.tester.getDialog().getResponse();
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
    }

    @Test
    public void testCookie() throws Exception {
        WebTester webTester = WebTesterFactory.createNewWebTester(this.environmentData);
        webTester.getTestContext().addCookie("JSESSIONID", "bad-cookie");
        webTester.beginAt("/?os_authType=cookie");
        WebResponse response = webTester.getDialog().getResponse();
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
    }

    @Test
    public void testAny_fail() throws Exception {
        WebTester webTester = WebTesterFactory.createNewWebTester(this.environmentData);
        webTester.getTestContext().addCookie("JSESSIONID", "bad-cookie");
        webTester.beginAt("/?os_authType=any");
        WebResponse response = webTester.getDialog().getResponse();
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
    }

    @Test
    public void testAny_anon() throws Exception {
        WebTester webTester = WebTesterFactory.createNewWebTester(this.environmentData);
        webTester.beginAt("/?os_authType=any");
        WebResponse response = webTester.getDialog().getResponse();
        Assert.assertEquals((long)200L, (long)response.getResponseCode());
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
    }
}

