/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.ComponentManagerControl;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SkipCacheCheck;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.atlassian.jira.util.SlowTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.LICENSING, Category.DATABASE})
@LoginAs(user="admin")
@SkipCacheCheck
public class TestSetup
extends BaseJiraFuncTest {
    private static final String CONFIGURE_APP_PROPERTIES_TITLE = "Set up application properties";
    private static final String SET_UP_LICENSE = "Specify your license key";
    private static final String SET_UP_ADMIN_ACCOUNT_TITLE = "Set up administrator account";
    private static final String URL_LICENSE_VALIDATION = "/secure/SetupLicense!validateLicense.jspa";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    private String xsrfToken;

    @Test
    public void testSetupIsXsrfProtected() {
        String[] xsrfTokenMissing;
        this.administration.restoreBlankInstance();
        for (String tokenMissing : xsrfTokenMissing = new String[]{"SetupDatabase.jspa", "SetupApplicationProperties.jspa", "SetupAdminAccount.jspa", "SetupAccount.jspa", "SetupMailNotifications.jspa", "SetupComplete.jspa", "SetupImport.jspa", "SetupFinishing.jspa"}) {
            this.tester.gotoPage("/secure/" + tokenMissing);
            this.assertError403();
        }
    }

    @Test
    public void testSetupCannotBeRunTwice() {
        this.administration.restoreBlankInstance();
        String[] actions = new String[]{"SetupDatabase.jspa", "SetupDatabase!default.jspa", "SetupApplicationProperties.jspa", "SetupApplicationProperties!default.jspa", "SetupAdminAccount.jspa", "SetupAdminAccount!default.jspa", "SetupAccount.jspa", "SetupAccount!default.jspa", "SetupMailNotifications.jspa", "SetupMailNotifications!default.jspa", "SetupComplete.jspa", "SetupComplete!default.jspa", "SetupImport.jspa", "SetupImport!default.jspa", "SetupImport!finish.jspa", "SetupFinishing!default.jspa"};
        String[] views = new String[]{"setup-application-properties.jsp", "setup-admin-account.jsp", "setup-mail-notifications.jsp", "setup-import.jsp"};
        HtmlPage page = new HtmlPage(this.tester);
        page.getFreshXsrfToken();
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", this.tester.getTestContext().getBaseUrl());
        for (String action : actions) {
            this.tester.gotoPage(page.addXsrfToken("/secure/" + action));
            this.assertSetupAlreadyLong();
        }
        for (String view : views) {
            this.tester.gotoPage("/views/" + view);
            this.assertSetupAlreadyShort();
        }
    }

    @Test
    public void testMissingTitle() {
        this.restoreEmptyInstance();
        this.gotoSetUpApplicationProperties();
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "");
        this.tester.submit();
        this.tester.assertTextPresent(CONFIGURE_APP_PROPERTIES_TITLE);
        this.tester.assertTextPresent("You must specify a title.");
    }

    @Test
    public void testInvalidBaseUrls() throws Exception {
        String[] invalidBaseUrls = new String[]{"", "http", "http://", "http://*&^%$#@", "http://example url.com:8090", "ldap://example.url.com:8090", "http://example.url.com:not_a_port", "http://example.url.com:8090/invalid path"};
        this.restoreEmptyInstance();
        this.gotoSetUpApplicationProperties();
        for (String invalidBaseUrl : invalidBaseUrls) {
            this.tester.setFormElement("baseURL", invalidBaseUrl);
            this.tester.submit();
            this.tester.assertTextPresent("The URL specified is not valid.");
        }
    }

    @Test
    public void testMissingLicense() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.submit();
        this.tester.assertTextPresent(SET_UP_LICENSE);
    }

    @Test
    public void testInvalidLicense() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", "blah");
        this.tester.submit();
        this.tester.assertTextPresent(SET_UP_LICENSE);
    }

    @Test
    public void testInvalidSmtpPorts() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.doSetupLicense();
        this.doSetUpAdminAccount();
        try {
            this.tester.checkRadioOption("noemail", "false");
            this.tester.setFormElement("serverName", "localhost");
            this.tester.setFormElement("port", "-1");
            this.tester.submit("finish");
            this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
            this.tester.setFormElement("serverName", "localhost");
            this.tester.setFormElement("port", String.valueOf(65536));
            this.tester.submit("finish");
            this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
        }
        finally {
            this.tester.setFormElement("serverName", "localhost");
            this.tester.setFormElement("port", "23000");
            this.tester.submit("finish");
        }
    }

    @Test
    public void testSetupWithDefaulExctDirectories() {
        this.restoreEmptyInstance();
        this.gotoSetUpApplicationProperties();
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "My Jira");
        this.tester.submit();
        this.doSetupLicense();
        this.doSetUpAdminAccountAndEmailNotifications();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "h2"), "Attachments");
        Assert.assertNotNull((Object)this.tester.getDialog().getWebTableBySummaryOrId("table-AttachmentSettings"));
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowHeading(1)), "Allow attachments");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowValue(1)), "ON");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowHeading(2)), "Attachments location");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowValue(2)), "Jira home");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INDEXING);
        this.tester.assertTextPresent("Re-indexing");
        this.administration.services().goTo();
        this.tester.assertTextPresent("Backup Service");
        this.tester.assertTextPresent("<strong>USE_DEFAULT_DIRECTORY:</strong> true");
        this.tester.assertTextNotPresent("DIR_NAME:");
        this.assertTimeTrackingActivationAndDefaultValues();
        this.assertIssueLinking();
    }

    private String tableAttachmentSettingsRowHeading(int rowNumber) {
        return "//table[@id='table-AttachmentSettings']/tbody/tr[" + rowNumber + "]/td/strong";
    }

    private String tableAttachmentSettingsRowValue(int rowNumber) {
        return "//table[@id='table-AttachmentSettings']/tbody/tr[" + rowNumber + "]/td";
    }

    @Test
    public void testSetupImportMissingFilename() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import existing data");
        this.tester.setFormElement("filename", "");
        this.tester.submit();
        this.tester.assertTextPresent("Import existing data");
        this.tester.assertTextPresent("You must enter the location of an XML file.");
        this.tester.assertTextNotPresent("You must specify a location for index files");
    }

    @Test
    public void testSetupImportInvalidLicense() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import existing data");
        this.tester.setFormElement("filename", File.createTempFile("import", ".xml").getAbsolutePath());
        this.tester.setFormElement("license", "wrong");
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("Import existing data");
        this.tester.assertTextPresent("This license is invalid.");
        this.tester.assertTextNotPresent("You must enter the location of an XML file.");
    }

    @Test
    public void testSetupImportWithDodgyAttachmentPath() throws IOException {
        this.restoreEmptyInstance();
        File attachmentPath = File.createTempFile("testXmlImportWithInvalidAttachmentDirectory", null);
        attachmentPath.deleteOnExit();
        File dataFile = this.administration.replaceTokensInFile("TestSetupInvalidAttachmentPath.xml", (Map<String, String>)ImmutableMap.of((Object)"@@ATTACHMENT_PATH@@", (Object)attachmentPath.getAbsolutePath()));
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import existing data");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Cannot write to attachment directory. Check that the application server and Jira have permissions to write to: " + attachmentPath.getAbsolutePath());
    }

    @Test
    public void testSetupImportShouldDisplayAnErrorWhenAttemptingToDowngradeFromAnAllowedVersion() throws Exception {
        this.restoreEmptyInstance();
        File dataFile = new File(this.environmentData.getXMLDataLocation(), "TestImportDowngrade.xml");
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.textAssertions.assertTextPresent(this.locator.css("div.aui-message-error"), "You are attempting to import data from Jira X");
        this.textAssertions.assertTextPresent(this.locator.css("div.aui-message-error"), "Click here to acknowledge this error and proceed anyway.");
        this.assertions.assertNodeExists(this.locator.css("a#acknowledgeDowngradeError"));
    }

    @Test
    @SlowTest
    public void testSetupImportShouldAllowDowngradeOnceDowngradeErrorHasBeenAcknowledged() throws Exception {
        this.restoreEmptyInstance();
        File dataFile = new File(this.environmentData.getXMLDataLocation(), "TestImportDowngrade.xml");
        this.tester.gotoPage("secure/SetupImport!default.jspa?downgradeAnyway=true");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("You have finished importing your existing data, Jira is ready to use.  Please log in and get started.");
    }

    @Test
    public void testSetupWithForgedLicenseShouldShowWarningFlag() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.doSetupLicense(LicenseKeys.FORGED_LICENSE);
        this.tester.assertTextPresent("Installation step successful but verify license");
    }

    @Test
    public void testSetupWithLegitimateLicenseShouldNotShowWarningFlag() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.doSetupLicense(LicenseKeys.COMMERCIAL_DC);
        this.tester.assertTextNotPresent("Installation step successful but verify license");
    }

    private void restoreEmptyInstance() {
        this.administration.restoreNotSetupInstance();
    }

    private void assertTimeTrackingActivationAndDefaultValues() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.tester.assertTextPresent("The number of working hours per day is <b>8");
        this.tester.assertTextPresent("The number of working days per week is <b>5");
    }

    private void assertIssueLinking() {
        this.tester.gotoPage("secure/admin/ViewLinkTypes!default.jspa");
        WebPageLocator page = new WebPageLocator(this.tester);
        this.textAssertions.assertTextPresent(page, "Issue linking is currently ON.");
        this.textAssertions.assertTextSequence(page, new String[]{"Blocks", "blocks", "is blocked by"});
        this.textAssertions.assertTextSequence(page, new String[]{"Cloners", "clones", "is cloned by"});
        this.textAssertions.assertTextSequence(page, new String[]{"Duplicate", "duplicates", "is duplicated by"});
        this.textAssertions.assertTextSequence(page, new String[]{"Relates", "relates to", "relates to"});
    }

    private void assertError403() {
        this.tester.assertTextPresent("Forbidden (403)");
    }

    private void assertSetupAlreadyLong() {
        this.tester.assertTextPresent("Jira setup has already completed");
        this.tester.assertTextPresent("It seems that you have tried to set up Jira when this process has already been done.");
    }

    private void assertSetupAlreadyShort() {
        this.tester.assertTextPresent("Jira has already been set up.");
    }

    private void doConfigureApplicationProperties() {
        this.gotoSetUpApplicationProperties();
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "TestSetup Jira");
        this.tester.submit();
    }

    private void doSetUpAdminAccountAndEmailNotifications() {
        this.doSetUpAdminAccount();
        this.doSetUpEmailNotifications();
    }

    private void doSetUpEmailNotifications() {
        this.logger.log((Object)"Noemail");
        this.tester.submit("finish");
        this.logger.log((Object)"Noemail");
        this.tester.assertLinkPresent("header-details-user-fullname");
        this.navigation.disableWebSudo();
    }

    private void doSetUpAdminAccount() {
        this.tester.assertTextPresent(SET_UP_ADMIN_ACCOUNT_TITLE);
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
    }

    private void gotoSetUpApplicationProperties() {
        this.tester.gotoPage("secure/SetupApplicationProperties!default.jspa");
        this.tester.assertTextPresent(CONFIGURE_APP_PROPERTIES_TITLE);
        this.xsrfToken = new HtmlPage(this.tester).getXsrfToken();
    }

    private void doSetupLicense(License license) {
        this.tester.assertTextPresent(SET_UP_LICENSE);
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", license.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent(SET_UP_ADMIN_ACCOUNT_TITLE);
    }

    private void doSetupLicense() {
        this.doSetupLicense(LicenseKeys.COMMERCIAL_DC);
    }

    @Test
    public void testShouldGiveAdminApplicationAccess() {
        this.administration.restoreNotSetupInstance(LicenseKeys.DATA_CENTER_SOFTWARE.getLicenseString());
        this.doConfigureApplicationProperties();
        this.doSetupLicense(LicenseKeys.CORE_ROLE_DC);
        this.doSetUpAdminAccount();
        this.doSetUpEmailNotifications();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoPage(Navigation.AdminSection.SYSTEM_INFO.getUrl());
    }

    @Test
    public void testShouldGiveAdminMultiApplicationAccess() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.doSetupLicense(LicenseKeys.MULTI_ROLE_DC);
        this.doSetUpAdminAccount();
        this.doSetUpEmailNotifications();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoPage(Navigation.AdminSection.SYSTEM_INFO.getUrl());
        ImmutableSet expectedApplications = ImmutableSet.of((Object)"jira-servicedesk", (Object)"jira-software", (Object)"jira-reference", (Object)"jira-func-test", (Object)"jira-core");
        UserClient userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        Set actualApplications = (Set)userClient.get((String)"admin", (User.Expand[])new User.Expand[]{User.Expand.applicationRoles}).applicationRoles.items.stream().map(role -> role.key).collect(CollectorsUtil.toImmutableSet());
        Assert.assertEquals((String)"admin has access to all licensed apps", (Object)expectedApplications, (Object)actualApplications);
    }

    @Test
    public void testThatSetupConfiguresApplicationDefaults() {
        this.administration.restoreNotSetupInstance(LicenseKeys.TEST_ROLE_DC.getLicenseString());
        this.gotoSetUpApplicationProperties();
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "TestSetup Jira");
        this.tester.submit();
        this.doSetupLicense(LicenseKeys.TEST_ROLE_DC);
        this.doSetUpAdminAccount();
        this.doSetUpEmailNotifications();
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        String TEST_DEFAULT_GROUP_NAME = "jira-test-group";
        this.assertAllGlobalPermissionsPresent();
        this.assertAllGlobalPermissionsGrantedOnAdminGroup();
        this.assertAllGlobalPermissionsGrantedOnDefaultGroup("jira-test-group");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.setFormElement("userSearchFilter", "admin");
        this.tester.submit("");
        this.tester.assertTextPresent("admin");
        this.tester.assertTextPresent("jira-test-group");
    }

    @Test
    @SlowTest
    public void testPluginManagerIsFullyStartedAfterInitialImport() {
        this.administration.restoreDataSlowOldWay("blankprojects.xml");
        Assert.assertThat((Object)((Object)this.getBackdoor().componentManager().state().getPluginSystemState()), (Matcher)Matchers.is((Object)((Object)ComponentManagerControl.PluginSystemState.LATE_STARTED)));
    }

    @Test
    public void testThatCorrectApplicationsHaveDefaultUserGroupsSetUp() {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.doSetupLicense(LicenseKeys.MULTI_ROLE_DC);
        this.doSetUpAdminAccount();
        this.doSetUpEmailNotifications();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.assertTextPresent("jira-core-users");
        this.tester.assertTextPresent("jira-servicedesk-users");
        this.tester.assertTextPresent("jira-software-users");
    }

    private void assertAllGlobalPermissionsGrantedOnDefaultGroup(String defaultGroupName) {
        Arrays.stream(GlobalPermissionTableRow.values()).filter(globalPermission -> GlobalPermissionTableRow.ADMIN != globalPermission && GlobalPermissionTableRow.SYSTEM_ADMIN != globalPermission).forEach(globalPermission -> this.assertGlobalPermissionGrantedOnGroup((GlobalPermissionTableRow)((Object)globalPermission), defaultGroupName));
    }

    private void assertAllGlobalPermissionsGrantedOnAdminGroup() {
        Arrays.stream(GlobalPermissionTableRow.values()).forEach(globalPermission -> this.assertGlobalPermissionGrantedOnGroup((GlobalPermissionTableRow)((Object)globalPermission), "jira-administrators"));
    }

    private void assertGlobalPermissionGrantedOnGroup(GlobalPermissionTableRow globalPermission, String group) {
        this.assertGlobalPermissionTableCellHasText(globalPermission.row, 1, group);
    }

    private void assertAllGlobalPermissionsPresent() {
        Arrays.stream(GlobalPermissionTableRow.values()).forEach(globalPermission -> this.assertGlobalPermissionTableCellHasText(((GlobalPermissionTableRow)globalPermission).row, 0, ((GlobalPermissionTableRow)globalPermission).globalPermissionName));
    }

    private void assertGlobalPermissionTableCellHasText(int row, int column, String expectedText) {
        try {
            WebTable globalPermissionsTable = this.getTester().getDialog().getResponse().getTableWithID("global_perms");
            this.assertions.getTableAssertions().assertTableCellHasText(globalPermissionsTable, row, column, expectedText);
        }
        catch (SAXException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShouldPassLicenseValidationForValidLicenses() throws SAXException, IOException {
        this.administration.restoreNotSetupInstance(LicenseKeys.DATA_CENTER_SOFTWARE.getLicenseString());
        this.doConfigureApplicationProperties();
        this.assertLicense(true, LicenseKeys.COMMERCIAL_DC);
        this.assertLicenseRaw(true, LicenseKeys.NON_EXISTING_ROLE_DC);
        this.assertLicense(true, LicenseKeys.MULTI_ROLE_DC);
    }

    @Test
    public void testShouldFailLicenseValidationForInvalidLicenses() throws SAXException, IOException {
        this.restoreEmptyInstance();
        this.doConfigureApplicationProperties();
        this.assertLicenseRaw(false, LicenseKeys.INVALID_DC);
        this.assertLicense(false, LicenseKeys.V1_ENTERPRISE);
    }

    @Test
    public void testLicenseValidationEndpointReturnsJson() throws IOException, SAXException {
        this.xsrfToken = new HtmlPage(this.tester).getFreshXsrfToken();
        String license = "AAA<script>alert('test');</script>";
        WebResponse webResponse = this.tester.getDialog().getWebClient().sendRequest((WebRequest)this.licenseValidationRequest("AAA<script>alert('test');</script>"));
        Assert.assertEquals((Object)"application/json", (Object)webResponse.getContentType());
    }

    private void assertLicense(boolean valid, License license) throws SAXException, IOException {
        this.assertLicenseRaw(valid, license.getLicenseString());
    }

    private void assertLicenseRaw(boolean valid, String license) throws SAXException, IOException {
        WebResponse webResponse = this.tester.getDialog().getWebClient().sendRequest((WebRequest)this.licenseValidationRequest(license));
        if (valid) {
            Assert.assertThat((Object)webResponse.getResponseCode(), (Matcher)Matchers.is((Object)HttpStatus.OK.code));
        } else {
            Assert.assertThat((Object)webResponse.getResponseCode(), (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        }
    }

    private PostMethodWebRequest licenseValidationRequest(String license) {
        String licenseValidationUrl = this.environmentData.getBaseUrl().toExternalForm() + URL_LICENSE_VALIDATION;
        PostMethodWebRequest request = new PostMethodWebRequest(licenseValidationUrl);
        String licString = license.replace("\n", "");
        request.setParameter("licenseToValidate", licString);
        if (StringUtils.isNotEmpty((CharSequence)this.xsrfToken)) {
            request.setParameter("atl_token", this.xsrfToken);
        }
        return request;
    }

    private static enum GlobalPermissionTableRow {
        SYSTEM_ADMIN(1, "Jira System Administrators"),
        ADMIN(2, "Jira Administrators"),
        BROWSE_USERS(3, "Browse Users"),
        CREATE_SHARED_OBJECTS(4, "Create Shared Objects"),
        MANAGE_GROUP_FILTER_SUBSCRIPTIONS(5, "Manage Group Filter Subscriptions"),
        BULK_CHANGE(6, "Bulk Change");

        private final int row;
        private final String globalPermissionName;

        private GlobalPermissionTableRow(int row, String globalPermissionName) {
            this.row = row;
            this.globalPermissionName = globalPermissionName;
        }
    }
}

