/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
@Restore(value="TestShowConstantsHelp.xml")
public class TestShowConstantsHelp
extends BaseJiraFuncTest {
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testShowConstantsHelpHasPermission() {
        this.tester.gotoPage("secure/ShowConstantsHelp.jspa");
        this.tester.assertTextPresent("Jira can be used to track many different types of issues");
    }

    @Test
    @RestoreBlankInstance
    public void testShowConstantsHelpDoesNotHavePermission() {
        this.navigation.logout();
        this.tester.gotoPage("secure/ShowConstantsHelp.jspa");
        this.tester.assertTextPresent("You are not logged in");
        this.navigation.login("admin", "admin");
    }

    @Test
    public void testShowConstantsHelpSecurityLevels() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.gotoPage("secure/ShowConstantsHelp.jspa");
        this.tester.assertTextPresent("Security Levels");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level 1", "Only developers are allowed to view this issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level 2", "All users are allowed to view this issue");
    }

    @Test
    @LoginAs(user="fred")
    public void testShowConstantsHelpSecurityLevelsSecurity() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.gotoPage("secure/ShowConstantsHelp.jspa");
        this.tester.assertTextPresent("Security Levels");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level 2", "All users are allowed to view this issue");
        this.tester.assertTextNotPresent("Security Level 1");
        this.tester.assertTextNotPresent("Only developers are allowed to view this issue");
    }
}

