/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.backdoor.ApplicationRoleControl;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.LICENSING})
public class TestSignupWithLicensing
extends BaseJiraFuncTest {
    private static final String USERNAME = "user";
    private static final String ENGLISH_LOCALE = "en_US";
    private ApplicationRoleControl roleClient;
    @Inject
    private Assertions assertions;
    @Inject
    private LocatorFactory locator;

    private static String removeI18nTags(String i18nString) {
        return i18nString.replaceAll("\\{[0-9]+\\}", "");
    }

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        this.backdoor.generalConfiguration().setContactAdminFormOff();
        this.roleClient = this.backdoor.applicationRoles();
        this.backdoor.generalConfiguration().setContactAdminFormOn();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
    }

    @Test
    public void testSignupForDefaultApplicationRoles() {
        this.checkSuccessUserCreate();
        Assert.assertTrue((String)"User is member of jira-users group", (boolean)this.backdoor.getTestkit().usersAndGroups().isUserInGroup(USERNAME, "jira-users"));
        Assert.assertFalse((String)"User is not member of jira-developers group", (boolean)this.backdoor.getTestkit().usersAndGroups().isUserInGroup(USERNAME, "jira-developers"));
    }

    @Test
    public void shouldCreateUserWhenGroupsExclusive() {
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", true, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.prepareToSignUp();
        Assert.assertThat(this.getDefaultGroups(), (Matcher)CoreMatchers.is((Object)ImmutableSet.of((Object)"jira-developers", (Object)"jira-users")));
        this.checkSuccessUserCreate();
        Assert.assertTrue((String)"User is member of jira-users group", (boolean)this.backdoor.getTestkit().usersAndGroups().isUserInGroup(USERNAME, "jira-users"));
        Assert.assertTrue((String)"User is member of jira-developers group", (boolean)this.backdoor.getTestkit().usersAndGroups().isUserInGroup(USERNAME, "jira-developers"));
    }

    @Test
    public void shouldSignupDisplayExceededMessageWhenOneApplicationExceeded() {
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", true, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.addUsersWithGroups(3, (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.navigation.logout();
        this.gotoSignupPage();
        this.assertCannotSignUpTitle();
        this.assertMessageContent("signup.limit.exceeded");
    }

    @Test
    public void shouldSignupFailWhenOneApplicationExceeded() {
        this.prepareToSignUp();
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", true, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.addUsersWithGroups(3, (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.submitSignup();
        this.assertCannotSignUpTitle();
        this.assertMessageContent("signup.limit.exceeded");
    }

    @Test
    public void shouldSignupDisplayAppAccessErrorMessageUpfrontWhenNoDefaultGroups() {
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", true, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of());
        this.navigation.logout();
        this.gotoSignupPage();
        this.assertCannotSignUpTitle();
        this.assertMessageContent("signup.app.access.error.upfront");
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.gotoSignupPage();
        this.assertions.assertNodeHasText(this.getTitleLocator(), "Sign up");
    }

    @Test
    public void shouldSignupDisplayAppAccessErrorMessageAfterSubmitWhenNoDefaultGroups() {
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", false, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.navigation.logout();
        this.gotoSignupPage();
        this.assertions.assertNodeHasText(this.getTitleLocator(), "Sign up");
        this.roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of());
        this.submitSignup();
        this.assertCannotSignUpTitle();
        this.assertMessageContent("signup.app.access.error.submit");
    }

    private void assertMessageContent(String i18nKey) {
        this.assertions.assertNodeHasText(this.locator.css("#content p"), TestSignupWithLicensing.removeI18nTags(this.backdoor.i18n().getText(i18nKey, ENGLISH_LOCALE)));
    }

    private void assertCannotSignUpTitle() {
        this.assertions.assertNodeHasText(this.getTitleLocator(), this.backdoor.i18n().getText("signup.cannot.signup.now", ENGLISH_LOCALE));
    }

    private Locator getTitleLocator() {
        return this.locator.css("#content h2");
    }

    private void addUsersWithGroups(int numberOfUsers, Iterable<String> groupNames) {
        for (int i = 0; i < numberOfUsers; ++i) {
            String userName = String.format("user-%d", i);
            this.backdoor.usersAndGroups().addUser(userName);
            groupNames.forEach(groupName -> this.backdoor.usersAndGroups().addUserToGroup(userName, groupName));
        }
    }

    private Set<String> getDefaultGroups() {
        return this.roleClient.getRoles().stream().filter(role -> role.isSelectedByDefault()).flatMap(role -> role.getDefaultGroups().stream()).collect(Collectors.toSet());
    }

    private void prepareToSignUp() {
        this.gotoSignupPage();
        this.assertions.assertNodeHasText(this.locator.css("h2"), "Sign up");
        this.tester.setWorkingForm("signup");
        this.tester.assertButtonPresent("signup-submit");
    }

    private void gotoSignupPage() {
        this.tester.gotoPage("secure/Signup!default.jspa");
    }

    private void checkSuccessUserCreate() {
        this.prepareToSignUp();
        this.submitSignup();
        this.assertions.assertNodeHasText(this.getTitleLocator(), "Congratulations!");
        this.assertions.assertNodeHasText(this.locator.css("#content .aui-message.aui-message-success"), TestSignupWithLicensing.removeI18nTags(this.backdoor.i18n().getText("signup.success", ENGLISH_LOCALE)));
    }

    private void submitSignup() {
        this.tester.setFormElement("username", USERNAME);
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit();
    }
}

