/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
public class TestXSS
extends BaseJiraFuncTest {
    private static final String XSS_ALERT_CONTENTS = "xss exploit";
    private static final String XSS_ALERT_RAW = "\"alert('xss exploit')";
    private static final String XSS_ALERT_ESCAPED = "&quot;alert(&#39;xss exploit&#39;)";
    private static final String XSS_RETURN_ATTACK_ENCODED = "javascript%3Aalert(%22owned%22)%3B";
    private static final String XSS_RETURN_ATTACK_RAW = "javascript:alert(\"owned\");";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testXSSReturnUrl() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "Test issue");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.gotoPage("/secure/AddComment!default.jspa?id=10000&returnUrl=javascript%3Aalert(%22owned%22)%3B");
        String responseHtml = this.tester.getDialog().getResponseText();
        boolean condition1 = responseHtml.indexOf(XSS_RETURN_ATTACK_ENCODED) == -1;
        Assert.assertTrue((boolean)condition1);
        boolean condition = responseHtml.indexOf(XSS_RETURN_ATTACK_RAW) == -1;
        Assert.assertTrue((boolean)condition);
    }

    @Test
    public void testXSSReturnUrlInViewUserProfiles() {
        this.tester.gotoPage("/secure/admin/user/ViewUserProjectRoles!default.jspa?atl_token=AKJmt_DiLV&name=admin&returnUrl=javascript%3Aalert(%22owned%22)%3B");
        String responseHtml = this.tester.getDialog().getResponseText();
        this.assertReturnUrlEscaped(responseHtml);
    }

    @Test
    public void testXSSFieldTypeInCreateCustomField() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        String atl_token = this.page.getXsrfToken();
        this.tester.gotoPage("http://localhost:8090/jira/secure/admin/CreateCustomField.jspa?currentStep=1&global=true&&issuetypes=-1&fieldType=<script>INJECT</script>&searcher=&description=&fieldName=&nextBtn=Next+%3e%3e&atl_token=" + atl_token);
        this.assertions.getTextAssertions().assertTextNotPresent("<script>INJECT</script>");
    }

    @Test
    public void testXSSPickers() {
        this.tester.gotoPage("/secure/popups/UserPickerBrowser.jspa?formName=startform&multiSelect=true&element=<script>alert('doo');</script>");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;doo&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('doo');</script>");
        this.tester.gotoPage("/secure/popups/GroupPickerBrowser.jspa?formName=startform&multiSelect=true&element=<script>alert('foo');</script>");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;foo&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('foo');</script>");
        this.tester.gotoPage("/secure/Dashboard.jspa?announcement_preview_banner_st=<script>alert('foobar');</script>");
        this.tester.assertTextNotPresent("<script>alert('foobar');</script>");
    }

    @Test
    public void testXSSIconPicker() {
        this.tester.gotoPage("/secure/popups/IconPicker.jspa?fieldType=<script>alert('XSS');</script>&formName=jiraform");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;XSS&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('XSS');</script>");
    }

    @Test
    public void testXssInHeaderUsername() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        this.navigation.login(XSS_ALERT_RAW, "password");
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    private void assertReturnUrlEscaped(String responseHtml) {
        Assert.assertFalse((boolean)responseHtml.contains(XSS_RETURN_ATTACK_ENCODED));
        Assert.assertFalse((boolean)responseHtml.contains(XSS_RETURN_ATTACK_RAW));
    }
}

